/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.GlassPane;
import com.gluonhq.charm.glisten.control.Dialog;
import com.gluonhq.charm.glisten.control.skin.HeaderDialogPanel;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Transition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.util.Duration;

public class TimePicker
extends Dialog<LocalTime> {
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass PSEUDO_CLASS_UNSELECTED = PseudoClass.getPseudoClass((String)"unselected");
    private static final Double DEGREES_90_IN_RADIANS = 1.5708;
    private static final Double WIDTH_OF_DIALOG = 0.8;
    private static final Double WIDTH_OF_CLOCK_INSIDE_DIALOG = 0.6;
    private final ObjectProperty<LocalTime> timeProperty = new SimpleObjectProperty((Object)this, "time", (Object)LocalTime.now());

    public TimePicker() {
        this(LocalTime.now());
    }

    public TimePicker(LocalTime time) {
        this.rootNode.getStyleClass().add((Object)"time-picker");
        this.setTime(time);
        TimePickerPanel panel = new TimePickerPanel(this.timeProperty());
        this.setContent((Node)panel);
        Button okBtn = new Button("OK");
        okBtn.setOnAction(e -> {
            this.setResult(this.getTime());
            this.hide();
        });
        Button cancelBtn = new Button("CANCEL");
        cancelBtn.setOnAction(e -> this.hide());
        this.getButtons().addAll((Object[])new ButtonBase[]{cancelBtn, okBtn});
    }

    public final ObjectProperty<LocalTime> timeProperty() {
        return this.timeProperty;
    }

    public final LocalTime getTime() {
        return (LocalTime)this.timeProperty.get();
    }

    public final void setTime(LocalTime value) {
        this.timeProperty.set((Object)value);
    }

    private static class Clock
    extends Region {
        private final ClockFace hoursClockFace;
        private final ClockFace clippedHoursClockFace;
        private final ClockFace minutesClockFace;
        private final ClockFace clippedMinutesClockFace;
        private ClockFace currentClockFace;
        private ClockFace currentClippedClockFace;
        private Group hand;
        private Circle innerCircle;
        private Line line;
        private Circle outerCircle;
        private int previousMinute;
        private boolean showHoursClock = true;
        private boolean isFirstRun = true;
        private final TimePickerPanel pickerPanel;
        private final ObjectProperty<LocalTime> timeProperty;

        public Clock(TimePickerPanel pickerPanel) {
            this.getStyleClass().add((Object)"clock");
            this.pickerPanel = pickerPanel;
            this.timeProperty = pickerPanel.timeProperty;
            this.hoursClockFace = new ClockFace();
            this.hoursClockFace.setElements(this.createHourElements());
            this.clippedHoursClockFace = new ClockFace();
            this.clippedHoursClockFace.getStyleClass().add((Object)"clipped");
            this.clippedHoursClockFace.setElements(this.createHourElements());
            this.minutesClockFace = new ClockFace();
            this.minutesClockFace.setElements(this.createMinuteElements(false));
            this.clippedMinutesClockFace = new ClockFace();
            this.clippedMinutesClockFace.getStyleClass().add((Object)"clipped");
            this.clippedMinutesClockFace.setElements(this.createMinuteElements(true));
            this.previousMinute = -1;
            this.currentClockFace = this.hoursClockFace;
            this.currentClippedClockFace = this.clippedHoursClockFace;
            this.getChildren().addAll((Object[])new Node[]{this.currentClockFace, this.currentClippedClockFace});
            this.buildClip();
            this.clippedHoursClockFace.setClip((Node)this.hand);
            this.timeProperty.addListener(o -> this.updateHandPosition());
            this.hoursClockFace.setOnMouseDragged(event -> this.onMousePressOrDraggedForHours((MouseEvent)event));
            this.hoursClockFace.setOnMousePressed(event -> this.onMousePressOrDraggedForHours((MouseEvent)event));
            this.minutesClockFace.setOnMouseDragged(event -> this.onMousePressOrDraggedForMinutes((MouseEvent)event));
            this.minutesClockFace.setOnMousePressed(event -> this.onMousePressOrDraggedForMinutes((MouseEvent)event));
        }

        private void onMousePressOrDraggedForMinutes(MouseEvent event) {
            int minute = this.getSelectedTime(event, this.minutesClockFace);
            if (this.previousMinute != -1) {
                this.clippedMinutesClockFace.getElements().get(this.previousMinute).setVisible(false);
            }
            this.previousMinute = minute;
            this.clippedMinutesClockFace.getElements().get(minute).setVisible(true);
            this.setMinute(minute);
        }

        private void onMousePressOrDraggedForHours(MouseEvent event) {
            int hour = this.getSelectedTime(event, this.hoursClockFace);
            this.setHour(hour);
        }

        private int getSelectedTime(MouseEvent event, ClockFace clockFace) {
            double mouseX = event.getSceneX();
            double mouseY = event.getSceneY();
            double minDistance = Double.MAX_VALUE;
            Node pickedNode = null;
            for (Node n : clockFace.getElements()) {
                Point2D nodePos = n.localToScene(0.0, 0.0);
                double nodeDistance = Math.sqrt(Math.pow(mouseX - nodePos.getX(), 2.0) + Math.pow(mouseY - nodePos.getY(), 2.0));
                if (!(nodeDistance < minDistance) && (nodeDistance != minDistance || (Integer)n.getUserData() % 5 != 0)) continue;
                minDistance = nodeDistance;
                pickedNode = n;
            }
            return (Integer)pickedNode.getUserData();
        }

        private void buildClip() {
            this.innerCircle = new Circle(3.0, (Paint)Color.RED);
            this.line = new Line();
            this.line.setStrokeWidth(2.0);
            this.outerCircle = new Circle(20.0, (Paint)Color.RED);
            this.hand = new Group(new Node[]{this.innerCircle, this.line, this.outerCircle});
        }

        public void setShowHoursClock(boolean showHoursClock) {
            if (this.showHoursClock == showHoursClock) {
                return;
            }
            if (!showHoursClock && this.showHoursClock) {
                this.previousMinute = -1;
            }
            this.showHoursClock = showHoursClock;
            ClockFace newClockFace = showHoursClock ? this.hoursClockFace : this.minutesClockFace;
            Duration duration = Duration.millis((double)150.0);
            Transition handFadeOut = this.fadeOut((Node)this.hand, duration);
            Transition fadeOut = this.fadeOut((Node)this.currentClockFace.elementsGroup, duration);
            fadeOut.setOnFinished(e -> {
                this.getChildren().removeAll((Object[])new Node[]{this.currentClockFace, this.currentClippedClockFace});
                this.currentClippedClockFace.setClip(null);
                this.currentClockFace = newClockFace;
                this.currentClockFace.elementsGroup.setOpacity(0.0);
                this.currentClippedClockFace = showHoursClock ? this.clippedHoursClockFace : this.clippedMinutesClockFace;
                this.buildClip();
                this.currentClippedClockFace.setClip((Node)this.hand);
                this.getChildren().addAll((Object[])new Node[]{this.currentClockFace, this.currentClippedClockFace});
                this.layoutChildren();
                this.updateHandPosition();
            });
            Transition handFadeIn = this.fadeIn((Node)this.hand, duration);
            FadeTransition fadeIn = new FadeTransition(duration);
            fadeIn.setNode((Node)newClockFace.elementsGroup);
            fadeIn.setFromValue(0.0);
            fadeIn.setToValue(1.0);
            fadeIn.setCycleCount(1);
            SequentialTransition transition = new SequentialTransition(new Animation[]{new ParallelTransition(new Animation[]{handFadeOut, fadeOut}), new ParallelTransition(new Animation[]{handFadeIn, fadeIn})});
            transition.play();
        }

        private Transition fadeOut(Node n, Duration duration) {
            FadeTransition fadeOut = new FadeTransition(duration);
            fadeOut.setNode(n);
            fadeOut.setFromValue(1.0);
            fadeOut.setToValue(0.0);
            return fadeOut;
        }

        private Transition fadeIn(Node n, Duration duration) {
            FadeTransition fadeOut = new FadeTransition(duration);
            fadeOut.setNode(n);
            fadeOut.setFromValue(0.0);
            fadeOut.setToValue(1.0);
            return fadeOut;
        }

        private List<Node> createHourElements() {
            ArrayList<Node> hours = new ArrayList<Node>();
            for (int i = 0; i < 12; ++i) {
                int hour = i == 0 ? 12 : i;
                Label label = new Label(hour + "");
                label.setUserData((Object)hour);
                hours.add((Node)label);
            }
            return hours;
        }

        private List<Node> createMinuteElements(boolean clipped) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int minute = 0; minute < 60; ++minute) {
                if (minute % 5 == 0) {
                    Label label = new Label();
                    nodes.add((Node)label);
                    label.setUserData((Object)minute);
                    if (minute == 0) {
                        label.setText("00");
                        continue;
                    }
                    if (minute % 5 != 0) continue;
                    label.setText(minute + "");
                    continue;
                }
                Circle circle = new Circle(5.0, (Paint)Color.web((String)"#C67631"));
                nodes.add((Node)circle);
                circle.setUserData((Object)minute);
                circle.setVisible(false);
            }
            return nodes;
        }

        private int getHour() {
            int hour = ((LocalTime)this.timeProperty.get()).getHour();
            return hour > 12 ? hour - 12 : hour;
        }

        private void updateHandPosition() {
            LocalTime time = (LocalTime)this.timeProperty.get();
            if (this.showHoursClock) {
                this.setHandPosition(this.getHour(), 12);
            } else {
                int minute = time.getMinute();
                this.setHandPosition(minute, 60);
            }
        }

        private void setHour(int hour) {
            if (!this.pickerPanel.isAM) {
                hour += 12;
            }
            LocalTime oldTime = (LocalTime)this.timeProperty.get();
            this.timeProperty.set((Object)LocalTime.of(hour % 24, oldTime.getMinute(), 0));
        }

        private void setMinute(int minute) {
            LocalTime oldTime = (LocalTime)this.timeProperty.get();
            this.timeProperty.set((Object)LocalTime.of(oldTime.getHour(), minute, 0));
        }

        private void setHandPosition(int value, int max) {
            double hourSlice = (double)value * Math.PI * 2.0 / (double)max;
            double offsetX = this.currentClockFace.getOffsetX();
            double offsetY = this.currentClockFace.getOffsetY();
            double halfAvgElementWidth = this.currentClockFace.getAvgElementWidth() / 2.0;
            double halfAvgElementHeight = this.currentClockFace.getAvgElementHeight() / 2.0;
            double endX = this.currentClockFace.getAngleXPos(hourSlice);
            double endY = this.currentClockFace.getAngleYPos(hourSlice);
            this.innerCircle.setCenterX(offsetX + halfAvgElementWidth);
            this.innerCircle.setCenterY(offsetY + halfAvgElementHeight);
            this.line.setStartX(offsetX + halfAvgElementWidth);
            this.line.setStartY(offsetY + halfAvgElementHeight);
            this.line.setEndX(endX + halfAvgElementWidth);
            this.line.setEndY(endY + halfAvgElementHeight);
            this.outerCircle.setCenterX(endX + halfAvgElementWidth);
            this.outerCircle.setCenterY(endY + halfAvgElementHeight);
        }

        protected void layoutChildren() {
            double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            double h = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
            this.currentClockFace.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), w, h);
            this.currentClippedClockFace.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), w, h);
            this.currentClockFace.layoutChildren();
            if (this.isFirstRun) {
                this.isFirstRun = false;
                this.updateHandPosition();
            }
        }
    }

    private static class ClockFace
    extends Region {
        private Region clockFace;
        private Circle clockClip;
        private final Group elementsGroup;
        private List<Node> elements;
        private double radius;
        private double offsetX;
        private double offsetY;
        private double avgElementWidth;
        private double avgElementHeight;

        public ClockFace() {
            this.getStyleClass().addAll((Object[])new String[]{"clock-face"});
            this.clockClip = new Circle(0.0, (Paint)Color.RED);
            this.clockFace = new Region();
            this.clockFace.getStyleClass().add((Object)"face");
            this.getChildren().add((Object)this.clockFace);
            this.clockFace.setClip((Node)this.clockClip);
            this.elementsGroup = new Group();
            this.getChildren().addAll((Object[])new Node[]{this.elementsGroup});
        }

        public void setElements(List<Node> elements) {
            if (this.elements != null && !this.elements.isEmpty()) {
                this.elementsGroup.getChildren().removeAll(this.elements);
            }
            this.elements = elements;
            if (this.elements != null && !this.elements.isEmpty()) {
                this.elementsGroup.getChildren().addAll(this.elements);
            }
        }

        public List<Node> getElements() {
            return this.elements;
        }

        public void layoutChildren() {
            double w = this.getWidth();
            double h = this.getHeight();
            double diameter = Math.min(w, h) * WIDTH_OF_CLOCK_INSIDE_DIALOG;
            this.radius = diameter / 2.0;
            double angleSlice = Math.PI * 2 / (double)this.elements.size();
            double angle = 0.0;
            Label firstElement = (Label)this.elements.get(0);
            double shiftX = firstElement.prefWidth(-1.0) / 2.0;
            this.offsetX = this.snapSize(w / 2.0 - shiftX);
            this.offsetY = this.snapSize(h / 2.0);
            boolean isHoursClock = firstElement.getText().equals("12");
            double minY = Double.MAX_VALUE;
            double minX = Double.MAX_VALUE;
            this.avgElementHeight = 0.0;
            this.avgElementWidth = 0.0;
            double maxY = 0.0;
            double maxX = 0.0;
            for (int i = 0; i < this.elements.size(); ++i) {
                Node n = this.elements.get(i);
                double nodeWidth = n.prefWidth(-1.0);
                double nodeHeight = n.prefHeight(nodeWidth);
                double nodeX = this.getAngleXPos(angle, this.radius, this.offsetX);
                double nodeY = this.getAngleYPos(angle, this.radius, this.offsetY);
                minX = Math.min(minX, nodeX);
                minY = Math.min(minY, nodeY);
                maxX = Math.max(maxX, nodeX + nodeWidth);
                maxY = Math.max(maxY, nodeY + nodeHeight);
                this.avgElementWidth += nodeWidth;
                this.avgElementHeight += nodeHeight;
                n.resize(this.snapSize(nodeWidth), this.snapSize(nodeHeight));
                if (isHoursClock) {
                    if (((Label)n).getText().length() > 1) {
                        nodeX -= nodeWidth / 4.0;
                    }
                } else {
                    nodeX -= 20.0;
                }
                n.relocate(this.snapPosition(nodeX), this.snapPosition(nodeY));
                angle += angleSlice;
            }
            this.avgElementWidth /= (double)this.elements.size();
            this.avgElementHeight /= (double)this.elements.size();
            this.elementsGroup.resizeRelocate(minX, minY, this.elementsGroup.prefWidth(-1.0), this.elementsGroup.prefHeight(-1.0));
            double clockFacePadding = 40.0;
            double clockFaceDiameter = Math.max(maxX - minX, maxY - minY) + 40.0;
            double clockFaceRadius = clockFaceDiameter / 2.0;
            this.clockFace.resizeRelocate(this.snapPosition(minX - 20.0 - shiftX / 2.0), this.snapPosition(minY - 20.0), clockFaceDiameter, clockFaceDiameter);
            this.clockClip.setRadius(clockFaceRadius);
            this.clockClip.setCenterX(clockFaceDiameter / 2.0);
            this.clockClip.setCenterY(clockFaceDiameter / 2.0);
        }

        protected double computePrefWidth(double height) {
            double ps = this.prefSize();
            return ps;
        }

        protected double computePrefHeight(double width) {
            return this.prefSize();
        }

        private double prefSize() {
            double h;
            GlassPane glassPane = AppManager.getInstance().getGlassPane();
            double w = glassPane.getWidth();
            if (w > (h = glassPane.getHeight())) {
                return this.snapSize(h * WIDTH_OF_DIALOG);
            }
            return this.snapSize(w * WIDTH_OF_DIALOG);
        }

        public double getAngleXPos(double angle) {
            return this.getAngleXPos(angle, this.radius, this.offsetX);
        }

        public double getAngleYPos(double angle) {
            return this.getAngleYPos(angle, this.radius, this.offsetY);
        }

        public double getAngleXPos(double angle, double radius, double offset) {
            return this.snapPosition(radius * Math.cos(angle - DEGREES_90_IN_RADIANS) + offset);
        }

        public double getAngleYPos(double angle, double radius, double offset) {
            return this.snapPosition(radius * Math.sin(angle - DEGREES_90_IN_RADIANS) + offset);
        }

        public double getRadius() {
            return this.radius;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public double getAvgElementWidth() {
            return this.avgElementWidth;
        }

        public double getAvgElementHeight() {
            return this.avgElementHeight;
        }
    }

    private static class TimePickerPanel
    extends HeaderDialogPanel {
        private ObjectProperty<LocalTime> timeProperty;
        private boolean isAM = true;
        private final HBox timeBox;
        private final Label hoursLabel;
        private final Label colonLabel;
        private final Label minutesLabel;
        private final Label amLabel;
        private final Label pmLabel;
        private Clock clockFace;

        public TimePickerPanel(ObjectProperty<LocalTime> timeProperty) {
            this.timeProperty = timeProperty;
            this.clockFace = new Clock(this);
            this.hoursLabel = new Label();
            this.hoursLabel.getStyleClass().addAll((Object[])new String[]{"hours"});
            this.hoursLabel.setOnMousePressed(e -> this.setShowHours(true));
            this.hoursLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                LocalTime time = (LocalTime)timeProperty.get();
                return time.getHour() > 12 ? time.getHour() - 12 + "" : time.getHour() + "";
            }, (Observable[])new Observable[]{timeProperty}));
            this.colonLabel = new Label(":");
            this.colonLabel.getStyleClass().addAll((Object[])new String[]{"colon"});
            this.minutesLabel = new Label();
            this.minutesLabel.getStyleClass().addAll((Object[])new String[]{"minutes"});
            this.minutesLabel.setOnMousePressed(e -> this.setShowHours(false));
            this.minutesLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                LocalTime time = (LocalTime)timeProperty.get();
                return time.getMinute() < 10 ? "0" + time.getMinute() : time.getMinute() + "";
            }, (Observable[])new Observable[]{timeProperty}));
            this.amLabel = new Label("A.M.");
            this.amLabel.getStyleClass().addAll((Object[])new String[]{"am"});
            this.amLabel.setOnMousePressed(e -> this.setAM(true));
            this.pmLabel = new Label("P.M.");
            this.pmLabel.getStyleClass().addAll((Object[])new String[]{"pm"});
            this.pmLabel.setOnMousePressed(e -> this.setAM(false));
            VBox meridianBox = new VBox(new Node[]{this.amLabel, this.pmLabel});
            meridianBox.setAlignment(Pos.CENTER);
            meridianBox.getStyleClass().add((Object)"meridians");
            this.timeBox = new HBox(5.0, new Node[]{this.hoursLabel, this.colonLabel, this.minutesLabel, meridianBox});
            this.timeBox.setMaxWidth(Double.MAX_VALUE);
            this.timeBox.setAlignment(Pos.CENTER_RIGHT);
            this.setHeader((Node)this.timeBox);
            this.setCenter((Node)this.clockFace);
            this.setShowHours(true);
            this.setAM(true);
            timeProperty.addListener(o -> {
                LocalTime time = (LocalTime)timeProperty.get();
                if (time == null) {
                    return;
                }
                this.setAM(time.getHour() <= 12);
            });
        }

        private void setShowHours(boolean showHours) {
            this.clockFace.setShowHoursClock(showHours);
            this.hoursLabel.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, showHours);
            this.hoursLabel.pseudoClassStateChanged(PSEUDO_CLASS_UNSELECTED, !showHours);
            this.minutesLabel.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, !showHours);
            this.minutesLabel.pseudoClassStateChanged(PSEUDO_CLASS_UNSELECTED, showHours);
        }

        private void setAM(boolean isAM) {
            this.isAM = isAM;
            this.amLabel.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, isAM);
            this.amLabel.pseudoClassStateChanged(PSEUDO_CLASS_UNSELECTED, !isAM);
            this.pmLabel.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, !isAM);
            this.pmLabel.pseudoClassStateChanged(PSEUDO_CLASS_UNSELECTED, isAM);
            LocalTime time = (LocalTime)this.timeProperty.get();
            if (time == null) {
                return;
            }
            if (isAM && time.getHour() > 13) {
                this.timeProperty.set((Object)LocalTime.of(time.getHour() - 12, time.getMinute()));
            } else if (!isAM && time.getHour() < 13) {
                this.timeProperty.set((Object)LocalTime.of(time.getHour() + 12, time.getMinute()));
            }
        }

        protected double computePrefWidth(double height) {
            return this.clockFace.prefWidth(height) + this.snappedLeftInset() + this.snappedRightInset();
        }
    }
}

