/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.animation.FadeInTransition;
import com.gluonhq.charm.glisten.animation.FadeOutTransition;
import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.GlassPane;
import com.gluonhq.charm.glisten.control.Toast;
import com.gluonhq.charm.glisten.layout.Layer;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.animation.Transition;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.util.Duration;

class ToastView
extends Layer {
    private final Label message = new Label();
    private final GlassPane glassPane = AppManager.getInstance().getGlassPane();
    private FadeInTransition showTransition;
    private Toast currentToast;
    private Transition autoHideTransition;

    ToastView() {
        this.setAutoHide(false);
        this.setMouseTransparent(true);
        this.setShowTransitionFactory(layer -> {
            if (this.showTransition == null) {
                this.showTransition = new FadeInTransition((Node)this);
                this.showTransition.setDelay(Duration.ZERO);
            }
            return this.showTransition;
        });
        this.setHideTransitionFactory(layer -> {
            FadeOutTransition hideTransition = new FadeOutTransition((Node)this);
            hideTransition.setOnFinished(e -> {
                this.setOpacity(0.0);
                this.showNextOrDispose();
            });
            return hideTransition;
        });
        this.getChildren().add((Object)this.message);
        this.getStyleClass().add((Object)"toast");
        this.setAutoHide(false);
    }

    @Override
    public void layoutChildren() {
        boolean isShowing = this.isShowing();
        this.message.setVisible(isShowing);
        if (!isShowing) {
            return;
        }
        double glassPaneWidth = this.glassPane.getWidth();
        double glassPaneHeight = this.glassPane.getHeight();
        double toastPrefWidth = this.message.prefWidth(-1.0);
        double toastPrefHeight = this.message.prefHeight(toastPrefWidth);
        double x = this.snapPosition(glassPaneWidth / 2.0 - toastPrefWidth / 2.0);
        double y = this.snapPosition(glassPaneHeight * 0.8);
        double width = this.snapSize(toastPrefWidth);
        double height = this.snapSize(toastPrefHeight);
        this.message.resizeRelocate(x, y, width, height);
        super.layoutChildren();
    }

    void show(Toast toast) {
        this.currentToast = toast;
        String message = toast.getMessage();
        Duration duration = toast.getDuration();
        this.message.setText(message);
        this.autoHideTransition = new PauseTransition(duration);
        this.autoHideTransition.setOnFinished(e -> {
            this.showTransition.stop();
            this.hide();
        });
        this.show();
        this.autoHideTransition.playFromStart();
    }

    void cancel(Toast toast) {
        if (toast.equals(this.currentToast)) {
            if (this.autoHideTransition != null && this.autoHideTransition.getStatus() == Animation.Status.RUNNING) {
                this.showTransition.stop();
                this.autoHideTransition.stop();
                this.hide();
            }
            this.showNextOrDispose();
        }
    }

    private void showNextOrDispose() {
        if (!Toast.pendingToasts.isEmpty()) {
            this.show(Toast.pendingToasts.remove(0));
        }
    }
}

