/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.skin.ToggleButtonGroupSkin;
import java.util.HashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;

@DefaultProperty(value="toggles")
public class ToggleButtonGroup
extends Control {
    private ObservableList<ToggleButton> toggles;
    private HashMap<ToggleButton, SelectionListener> toggleButtonToSelectionListener;
    private final ObjectProperty<SelectionMode> selectionType = new SimpleObjectProperty((Object)SelectionMode.SINGLE);
    private static final String DEFAULT_STYLE_CLASS = "toggle-button-group";

    public ToggleButtonGroup() {
        this.toggleButtonToSelectionListener = new HashMap();
        this.toggles = FXCollections.observableArrayList();
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.getToggles().addListener(c -> this.togglesChanged((ListChangeListener.Change<? extends ToggleButton>)c));
    }

    public ToggleButtonGroup(ToggleButton ... toggles) {
        this();
        this.getToggles().addAll((Object[])toggles);
    }

    public final ObjectProperty<SelectionMode> selectionTypeProperty() {
        return this.selectionType;
    }

    public final void setSelectionType(SelectionMode value) {
        this.selectionType.set((Object)value);
    }

    public final SelectionMode getSelectionType() {
        return (SelectionMode)this.selectionType.get();
    }

    public final ObservableList<ToggleButton> getToggles() {
        return this.toggles;
    }

    protected Skin<?> createDefaultSkin() {
        return new ToggleButtonGroupSkin(this);
    }

    private void togglesChanged(ListChangeListener.Change<? extends ToggleButton> changed) {
        while (changed.next()) {
            SelectionListener selectionListener;
            if (changed.wasAdded()) {
                for (ToggleButton toggleButton : changed.getAddedSubList()) {
                    selectionListener = new SelectionListener(toggleButton);
                    this.toggleButtonToSelectionListener.put(toggleButton, selectionListener);
                    toggleButton.selectedProperty().addListener((InvalidationListener)selectionListener);
                }
            }
            if (!changed.wasRemoved()) continue;
            for (ToggleButton toggleButton : changed.getRemoved()) {
                selectionListener = this.toggleButtonToSelectionListener.get(toggleButton);
                toggleButton.selectedProperty().removeListener((InvalidationListener)selectionListener);
                this.toggleButtonToSelectionListener.remove(toggleButton);
            }
        }
    }

    private class SelectionListener
    implements InvalidationListener {
        private ToggleButton toggleButton;

        public SelectionListener(ToggleButton toggleButton) {
            this.toggleButton = toggleButton;
        }

        public void invalidated(Observable observable) {
            if (ToggleButtonGroup.this.getSelectionType() == SelectionMode.SINGLE && this.toggleButton.isSelected()) {
                for (ToggleButton tb : ToggleButtonGroup.this.getToggles()) {
                    if (tb == this.toggleButton) continue;
                    tb.setSelected(false);
                }
            }
        }
    }
}

