/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.settings;

import com.gluonhq.charm.glisten.control.settings.Option;
import com.gluonhq.charm.glisten.control.settings.OptionEditor;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.util.StringConverter;

public abstract class OptionBase<T>
implements Option<T> {
    protected String caption;
    protected String description;
    protected String category;
    protected Node graphic;
    protected Property<T> value;
    protected boolean isEditable;
    protected Function<Option<T>, OptionEditor<T>> editorFactory;
    protected String extendedDescription;
    protected ObservableList<Option> children;
    protected StringConverter<T> stringConverter;
    protected Orientation layout;
    private final StringProperty id = new SimpleStringProperty();

    protected OptionBase(String caption) {
        this(null, caption, null, null, null, false, null);
    }

    protected OptionBase(String caption, String description, String category) {
        this(null, caption, description, category, null, false, null);
    }

    protected OptionBase(Node graphic, String caption, String description, String category) {
        this(graphic, caption, description, category, null, false, null);
    }

    protected OptionBase(String caption, String description, String category, Property<T> value, boolean isEditable) {
        this(null, caption, description, category, value, isEditable, null);
    }

    protected OptionBase(String caption, String description, String category, Property<T> value, boolean isEditable, Function<Option<T>, OptionEditor<T>> editorFactory) {
        this(null, caption, description, category, value, isEditable, editorFactory);
    }

    protected OptionBase(Node graphic, String caption, String description, String category, Property<T> value, boolean isEditable) {
        this(graphic, caption, description, category, value, isEditable, null);
    }

    protected OptionBase(Node graphic, String caption, String description, String category, Property<T> value, boolean isEditable, Function<Option<T>, OptionEditor<T>> editorFactory) {
        this.graphic = graphic;
        this.caption = caption;
        this.description = description;
        this.category = category;
        this.value = value;
        this.isEditable = isEditable;
        this.editorFactory = editorFactory;
        this.children = FXCollections.observableArrayList();
        this.layout = Orientation.HORIZONTAL;
    }

    @Override
    public Optional<Node> getGraphic() {
        return Optional.ofNullable(this.graphic);
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Optional<String> getExtendedDescription() {
        return Optional.ofNullable(this.extendedDescription);
    }

    public void setExtendedDescription(String value) {
        this.extendedDescription = value;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public abstract Property<T> valueProperty();

    @Override
    public Optional<Function<Option<T>, OptionEditor<T>>> editorFactoryProperty() {
        return Optional.ofNullable(this.editorFactory);
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public ObservableList<Option> getChildren() {
        return this.children;
    }

    public void setStringConverter(StringConverter value) {
        this.stringConverter = value;
    }

    @Override
    public Optional<StringConverter<T>> getStringConverter() {
        return Optional.ofNullable(this.stringConverter);
    }

    public static <T> Property<T> valueProperty(T value) {
        return new ReadOnlyObjectWrapper(value);
    }

    @Override
    public Orientation getLayout() {
        return this.layout;
    }

    public void setLayout(Orientation layout) {
        this.layout = layout;
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final void setId(String id) {
        this.id.setValue(id);
    }

    public final String getId() {
        return (String)this.id.get();
    }
}

