/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.AppBar;
import com.gluonhq.charm.glisten.control.ProgressBar;
import com.gluonhq.charm.glisten.layout.layer.MenuPopupView;
import com.gluonhq.charm.glisten.layout.layer.PopupView;
import com.gluonhq.charm.glisten.visual.MaterialDesignIcon;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class AppBarSkin
extends SkinBase<AppBar> {
    private static final PseudoClass PSEUDO_CLASS_PROGRESS_SHOWING = PseudoClass.getPseudoClass((String)"progress-showing");
    private static final int MIN_HEIGHT = 40;
    private final VBox navArea;
    private final VBox titleBox;
    private final HBox actionItems;
    private final AppBarOverFlowMenu overflowMenu;
    private ProgressBar progressBar;
    private ChangeListener<Number> progressListener = (observable, oldValue, newValue) -> {
        AppBar appBar = (AppBar)this.getSkinnable();
        if (appBar.isProgressBarVisible()) {
            if (appBar.isAutoHideProgressBar() && newValue.doubleValue() >= 1.0) {
                this.removeProgressBar();
                appBar.setProgressBarVisible(false);
            } else {
                if (this.progressBar == null) {
                    this.progressBar = new ProgressBar();
                    appBar.pseudoClassStateChanged(PSEUDO_CLASS_PROGRESS_SHOWING, true);
                    this.getChildren().add((Object)this.progressBar);
                }
                this.progressBar.setProgress(newValue.doubleValue());
            }
        }
    };

    public AppBarSkin(AppBar control) {
        super((Control)control);
        this.navArea = new VBox();
        this.navArea.getStyleClass().setAll((Object[])new String[]{"nav-area"});
        this.titleBox = new VBox();
        this.titleBox.getStyleClass().setAll((Object[])new String[]{"title-box"});
        this.actionItems = new HBox();
        this.actionItems.getStyleClass().setAll((Object[])new String[]{"action-items"});
        this.actionItems.spacingProperty().bind((ObservableValue)((AppBar)this.getSkinnable()).spacingProperty());
        this.overflowMenu = new AppBarOverFlowMenu();
        this.getChildren().addAll((Object[])new Node[]{this.navArea, this.titleBox, this.actionItems, this.overflowMenu});
        this.refreshAppBar();
        control.titleProperty().addListener(observable -> this.refreshTitle());
        control.navIconProperty().addListener(observable -> this.refreshNavIcon());
        control.getActionItems().addListener(observable -> this.refreshActionItems());
        control.getMenuItems().addListener(observable -> this.refreshOverFlowMenu());
        control.progressBarVisibleProperty().addListener(observable -> this.refreshProgressBar());
        control.autoHideProgressBarProperty().addListener(observable -> this.refreshProgressBar());
    }

    private void refreshAppBar() {
        this.refreshNavIcon();
        this.refreshTitle();
        this.refreshActionItems();
        this.refreshOverFlowMenu();
        this.refreshProgressBar();
    }

    private void refreshNavIcon() {
        this.navArea.getChildren().clear();
        Node navIcon = ((AppBar)this.getSkinnable()).getNavIcon();
        if (navIcon != null) {
            this.navArea.getChildren().setAll((Object[])new Node[]{navIcon});
        }
    }

    private void refreshTitle() {
        this.titleBox.getChildren().clear();
        Node title = ((AppBar)this.getSkinnable()).getTitle();
        if (title != null) {
            this.titleBox.getChildren().setAll((Object[])new Node[]{title});
        } else {
            this.titleBox.getChildren().setAll((Object[])new Node[]{new Label("")});
        }
    }

    private void refreshActionItems() {
        this.actionItems.getChildren().setAll(((AppBar)this.getSkinnable()).getActionItems());
    }

    private void refreshOverFlowMenu() {
        ObservableList<MenuItem> overflowMenuItems = ((AppBar)this.getSkinnable()).getMenuItems();
        this.overflowMenu.getItems().setAll(overflowMenuItems);
        if (!overflowMenuItems.isEmpty()) {
            this.overflowMenu.setVisible(true);
            this.overflowMenu.setManaged(true);
        } else {
            this.overflowMenu.setVisible(false);
            this.overflowMenu.setManaged(false);
        }
    }

    private void refreshProgressBar() {
        this.removeProgressBar();
        AppBar appBar = (AppBar)this.getSkinnable();
        if (appBar.isProgressBarVisible()) {
            double progress = appBar.getProgress();
            if (appBar.isAutoHideProgressBar() && progress == 1.0) {
                this.removeProgressBar();
            } else {
                if (this.progressBar == null) {
                    this.progressBar = new ProgressBar();
                    appBar.pseudoClassStateChanged(PSEUDO_CLASS_PROGRESS_SHOWING, true);
                    this.getChildren().add((Object)this.progressBar);
                }
                this.progressBar.setProgress(progress);
            }
        }
        appBar.progressProperty().addListener(this.progressListener);
    }

    private void removeProgressBar() {
        Optional<Node> progressBar = this.getProgressBar();
        progressBar.ifPresent(pb -> {
            this.getChildren().remove(pb);
            this.progressBar = null;
        });
        ((AppBar)this.getSkinnable()).progressProperty().removeListener(this.progressListener);
        ((AppBar)this.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_PROGRESS_SHOWING, false);
    }

    private Optional<Node> getProgressBar() {
        for (Node node : this.getChildren()) {
            if (!(node instanceof ProgressBar)) continue;
            return Optional.of(node);
        }
        return Optional.empty();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double currentX = x;
        double spacing = ((AppBar)this.getSkinnable()).getSpacing();
        double effectiveHeight = ((AppBar)this.getSkinnable()).prefHeight(w) - y - this.snappedBottomInset();
        double effectiveWidth = w + this.snappedLeftInset();
        this.navArea.resizeRelocate(currentX, y, this.navArea.prefWidth(effectiveHeight), effectiveHeight);
        double titleBoxWidth = this.titleBox.prefWidth(effectiveHeight);
        double expectedTitleBoxWidth = w - ((currentX += this.snapPosition(this.navArea.prefWidth(effectiveHeight)) + spacing) + this.actionItems.prefWidth(h) + (this.overflowMenu.isVisible() ? spacing + this.overflowMenu.prefWidth(h) : 0.0));
        titleBoxWidth = titleBoxWidth > expectedTitleBoxWidth ? expectedTitleBoxWidth : titleBoxWidth;
        this.titleBox.resizeRelocate(currentX, y, titleBoxWidth, effectiveHeight);
        double overflowMenuWidth = this.snapPosition(this.overflowMenu.prefWidth(h));
        double actionItemWidth = this.overflowMenu.isVisible() ? effectiveWidth - (currentX + spacing + overflowMenuWidth) : effectiveWidth - (currentX += this.snapPosition(titleBoxWidth) + spacing);
        double actionItemMinWidth = this.actionItems.minWidth(effectiveHeight);
        actionItemWidth = actionItemWidth > actionItemMinWidth ? actionItemWidth : actionItemMinWidth;
        this.actionItems.resizeRelocate(currentX, y, actionItemWidth, effectiveHeight);
        this.overflowMenu.resizeRelocate(currentX += actionItemWidth + spacing, y, overflowMenuWidth, effectiveHeight);
        if (((AppBar)this.getSkinnable()).isProgressBarVisible() && this.progressBar != null) {
            double progressBarWidth = w + this.snappedLeftInset() + this.snappedRightInset();
            double progressBarHeight = this.progressBar.prefHeight(progressBarWidth);
            this.progressBar.resizeRelocate(0.0, y + effectiveHeight, progressBarWidth, progressBarHeight);
        }
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + 40.0 + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.navArea.prefWidth(height) + this.titleBox.prefWidth(height) + this.actionItems.prefWidth(height) + this.overflowMenu.prefWidth(height) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double tempPrefHeight = 0.0;
        for (Node node : this.getChildren()) {
            tempPrefHeight = Math.max(node.prefHeight(-1.0), tempPrefHeight);
        }
        double prefHeight = topInset + tempPrefHeight + bottomInset;
        double minHeight = this.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
        return prefHeight > minHeight ? prefHeight : minHeight;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    private class AppBarOverFlowMenu
    extends StackPane {
        private final Button menuButton = MaterialDesignIcon.MORE_VERT.button();
        private MenuPopupView popup;
        private final Menu menu;

        public AppBarOverFlowMenu() {
            this.getStyleClass().setAll((Object[])new String[]{"app-bar-overflow-button"});
            this.setAccessibleRole(AccessibleRole.BUTTON);
            this.setFocusTraversable(true);
            this.menuButton.setOnAction(event -> {
                this.fire();
                event.consume();
            });
            this.visibleProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue() && this.getChildren().isEmpty()) {
                    this.setFocusTraversable(true);
                }
            });
            this.menu = new Menu();
            this.popup = new MenuPopupView((Node)this.menuButton, this.menu);
            this.popup.setSide(PopupView.PopupSide.RIGHT);
            this.getChildren().add((Object)this.menuButton);
        }

        private ObservableList<MenuItem> getItems() {
            return this.menu.getItems();
        }

        private void fire() {
            if (this.popup.isShowing()) {
                this.popup.hide();
            } else {
                this.popup.show();
            }
        }
    }
}

