/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.AutoCompleteTextField;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import com.gluonhq.charm.glisten.control.skin.TextFieldSkin;
import com.gluonhq.charm.glisten.layout.layer.PopupView;
import java.util.Collections;
import java.util.List;
import javafx.animation.PauseTransition;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class AutoCompleteTextFieldSkin<T>
extends TextFieldSkin {
    public static final String SET_VALUE = "setValue";
    public static final String DEFAULT_RESULT_NODE_FACTORY = "defaultResultNodeFactory";
    private final PopupView autoCompletePopup;
    private final VBox autoCompleteContent;
    private boolean isSelection;

    public AutoCompleteTextFieldSkin(AutoCompleteTextField control) {
        super(control);
        PauseTransition waitTransition = new PauseTransition(control.getCompleterWaitDuration());
        waitTransition.setOnFinished(event -> control.search());
        this.autoCompleteContent = new VBox();
        this.autoCompleteContent.getStyleClass().add((Object)"popup-content");
        this.autoCompletePopup = new PopupView((Node)control, (Node)this.autoCompleteContent){

            @Override
            protected boolean useContentSize() {
                return false;
            }
        };
        this.autoCompletePopup.getStyleClass().add((Object)"auto-complete-popup");
        this.autoCompletePopup.setOnShown((EventHandler<LifecycleEvent>)((EventHandler)e -> {
            if (this.innerTextControl.getText().isEmpty() || !this.innerTextControl.isFocused()) {
                this.autoCompletePopup.hide();
            }
        }));
        this.innerTextControl.textProperty().addListener((observable, oldValue, newValue) -> {
            if (control.getCompleterMode() == AutoCompleteTextField.CompleterMode.SEARCH_AUTOMATICALLY) {
                waitTransition.playFromStart();
            }
        });
        this.innerTextControl.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.autoCompletePopup.hide();
            }
        });
        control.addEventHandler(AutoCompleteTextField.AutoCompleteEvent.ON_SEARCH, event -> {
            if (!this.isSelection) {
                this.onSearch();
            }
        });
    }

    private void onSearch() {
        final AutoCompleteTextField textField = (AutoCompleteTextField)this.control;
        Task task = new Task<List<T>>(){

            protected List<T> call() {
                if (textField.getText().isEmpty()) {
                    return Collections.emptyList();
                }
                return textField.getCompleter().apply(textField.getText());
            }
        };
        task.setOnSucceeded(arg_0 -> this.lambda$onSearch$5((Task)task, textField, arg_0));
        Thread thread = new Thread((Runnable)task);
        thread.setDaemon(true);
        thread.start();
    }

    private void showAutoComplete(AutoCompleteTextField<T> textField, List<T> results) {
        this.autoCompleteContent.getChildren().clear();
        double width = this.control.getBoundsInLocal().getWidth();
        double height = this.control.prefHeight(width);
        this.autoCompletePopup.setVerticalOffset(height);
        this.autoCompletePopup.setPrefWidth(width);
        for (T result : results) {
            Node node = textField.getResultNodeFactory().apply(result);
            if (DEFAULT_RESULT_NODE_FACTORY.equals(node.getUserData())) {
                Insets textFieldPadding = this.innerTextControl.getPadding();
                node.setStyle("-fx-padding: 0 " + (textFieldPadding.getRight() - 1.0) + " 0 " + (textFieldPadding.getLeft() + 1.0) + ";");
            }
            node.setOnMousePressed(event -> {
                this.isSelection = true;
                StringConverter converter = textField.getConverter();
                textField.setText(converter == null ? result.toString() : converter.toString(result));
                textField.getProperties().put((Object)SET_VALUE, result);
                this.autoCompletePopup.hide();
                this.isSelection = false;
            });
            this.autoCompleteContent.getChildren().add((Object)node);
        }
        this.autoCompletePopup.show();
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.innerTextControl.prefWidth(-1.0) + rightInset;
    }

    private /* synthetic */ void lambda$onSearch$5(Task task, AutoCompleteTextField textField, WorkerStateEvent e) {
        if (((List)task.getValue()).isEmpty()) {
            this.autoCompletePopup.hide();
        } else {
            this.showAutoComplete(textField, (List)task.getValue());
        }
    }
}

