/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.AvatarPane;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;

public class AvatarPaneSkin<T>
extends SkinBase<AvatarPane<T>> {
    private static final Duration animateUpDownDuration = Duration.millis((double)350.0);
    private T selectedHeader;
    private final HeaderPane header = new HeaderPane();
    private Node selectedContent;
    private double oldContentHeight;
    private final Rectangle contentClip;
    private double frac = 0.0;
    private boolean animateDown = true;
    private boolean animateUp = false;
    private double headerAnimateFrac = 0.0;
    private boolean animateEntirely = false;
    private Runnable exitAction;

    public AvatarPaneSkin(AvatarPane<T> control) {
        super(control);
        this.getChildren().add((Object)this.header);
        this.contentClip = new Rectangle();
        this.exitAction = control.getExitAction();
        control.valueProperty().addListener(o -> this.updateSelection());
        control.expandedProperty().addListener(o -> this.updateExpansion());
        control.exitActionProperty().addListener(o -> {
            this.exitAction = control.getExitAction();
        });
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        if (this.animateDown || this.animateUp) {
            final boolean _animateDown = this.animateDown;
            boolean _animateUp = this.animateUp;
            this.animateDown = false;
            this.animateUp = false;
            Transition transition = new Transition(){
                {
                    this.setCycleDuration(animateUpDownDuration);
                }

                protected void interpolate(double frac) {
                    AvatarPaneSkin.this.headerAnimateFrac = _animateDown ? frac : 1.0 - frac;
                    ((AvatarPane)AvatarPaneSkin.this.getSkinnable()).requestLayout();
                }
            };
            transition.setOnFinished(e -> {
                if (_animateDown) {
                    this.updateSelection();
                }
                if (this.exitAction != null) {
                    this.exitAction.run();
                }
            });
            if (_animateUp) {
                this.header.animateAvatars(false, () -> transition.play());
            } else {
                transition.play();
            }
        }
        double headerHeight = this.header.prefHeight(contentWidth - (this.snappedLeftInset() + this.snappedRightInset())) * this.headerAnimateFrac;
        this.header.resizeRelocate(contentX, contentY, contentWidth, headerHeight);
        if (this.selectedContent != null) {
            this.selectedContent.resizeRelocate(contentX, contentY + headerHeight, contentWidth, contentHeight - headerHeight);
        }
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        boolean isExpanded = ((AvatarPane)this.getSkinnable()).isExpanded();
        double headerPrefHeight = this.header.prefHeight(width);
        double contentPrefHeight = !isExpanded ? 0.0 : this.selectedContent.prefHeight(width);
        double ph = topInset + headerPrefHeight + contentPrefHeight + bottomInset;
        return ph;
    }

    public final void requestAnimateUp() {
        this.animateUp = true;
        ((AvatarPane)this.getSkinnable()).requestLayout();
    }

    public final void requestAnimateDown() {
        this.animateDown = true;
        ((AvatarPane)this.getSkinnable()).requestLayout();
    }

    private void updateSelection() {
        this.selectedHeader = ((AvatarPane)this.getSkinnable()).getValue();
        this.header.arrowStartX = this.header.arrowRegion.getLayoutX() + this.header.arrowRegion.getWidth() / 2.0;
        Callback contentFactory = ((AvatarPane)this.getSkinnable()).getContentFactory();
        if (contentFactory == null) {
            throw new IllegalStateException("contentFactory is null");
        }
        if (this.selectedContent != null) {
            this.oldContentHeight = this.selectedContent instanceof Region ? this.selectedContent.prefHeight(((AvatarPane)this.getSkinnable()).getWidth()) : 0.0;
            this.getChildren().remove((Object)this.selectedContent);
            this.selectedContent.setClip(null);
        }
        Transition transition = new Transition(){
            {
                this.setCycleDuration(Duration.millis((double)250.0));
            }

            protected void interpolate(double frac) {
                AvatarPaneSkin.this.frac = frac;
                AvatarPaneSkin.this.header.requestLayout();
                ((AvatarPane)AvatarPaneSkin.this.getSkinnable()).requestLayout();
            }
        };
        transition.setOnFinished(e -> {
            AvatarPane control = (AvatarPane)this.getSkinnable();
            if (control == null) {
                return;
            }
            if (control.isExpanded()) {
                this.selectedContent = (Node)contentFactory.call(this.selectedHeader);
                this.selectedContent.getStyleClass().add((Object)"content");
                this.getChildren().add((Object)this.selectedContent);
            }
        });
        transition.play();
    }

    private void updateExpansion() {
        if (!((AvatarPane)this.getSkinnable()).isCollapsible()) {
            return;
        }
        if (((AvatarPane)this.getSkinnable()).isExpanded() && this.getChildren().contains((Object)this.selectedContent)) {
            return;
        }
        if (((AvatarPane)this.getSkinnable()).isExpanded()) {
            this.getChildren().add((Object)this.selectedContent);
        }
        Transition transition = new Transition(){
            {
                this.setCycleDuration(Duration.millis((double)250.0));
            }

            protected void interpolate(double frac) {
                AvatarPaneSkin.this.frac = frac;
                AvatarPaneSkin.this.header.requestLayout();
                ((AvatarPane)AvatarPaneSkin.this.getSkinnable()).requestLayout();
            }
        };
        transition.setOnFinished(e -> {
            this.animateEntirely = false;
            if (!((AvatarPane)this.getSkinnable()).isExpanded()) {
                this.getChildren().remove((Object)this.selectedContent);
            }
        });
        this.animateEntirely = true;
        transition.play();
    }

    private TranslateTransition createTranslateAnimation(Node node, double animationDuration, double startDelay) {
        TranslateTransition transition = new TranslateTransition(Duration.millis((double)animationDuration), node);
        transition.setInterpolator(Interpolator.EASE_OUT);
        transition.setCycleCount(1);
        transition.setDelay(Duration.millis((double)startDelay));
        return transition;
    }

    private class HeaderPane
    extends Region {
        private static final String CLICK_HANDLER = "clickHandler";
        private static final double PREF_AVATAR_SPACING = 10.0;
        private static final double ARROW_V_GAP = 5.0;
        private final Map<T, Node> itemNodeMap;
        private final Region arrowRegion;
        private double arrowStartX;
        private boolean snapArrow = true;
        private boolean firstDisplay = true;

        public HeaderPane() {
            this.getStyleClass().add((Object)"header");
            this.arrowRegion = new Region();
            this.arrowRegion.getStyleClass().add((Object)"arrow");
            this.arrowRegion.setManaged(false);
            this.itemNodeMap = new HashMap();
            this.updateHeader();
            ((AvatarPane)AvatarPaneSkin.this.getSkinnable()).itemsProperty().addListener(o -> this.updateHeader());
            this.widthProperty().addListener(o -> {
                this.snapArrow = true;
            });
        }

        private void updateHeader() {
            AvatarPane control = (AvatarPane)AvatarPaneSkin.this.getSkinnable();
            Callback avatarFactory = control.getAvatarFactory();
            if (avatarFactory == null) {
                throw new IllegalStateException("AvatarFactory is null");
            }
            for (Node child : this.getChildren()) {
                EventHandler clickHandler = (EventHandler)child.getProperties().get((Object)CLICK_HANDLER);
                if (clickHandler == null) continue;
                child.removeEventHandler(MouseEvent.MOUSE_CLICKED, clickHandler);
                child.getProperties().remove((Object)CLICK_HANDLER);
            }
            this.getChildren().clear();
            for (Object element : control.getItems()) {
                Node node = (Node)avatarFactory.call(element);
                if (node == null) continue;
                EventHandler clickHandler = e -> {
                    Object oldSelectedElement = control.getValue();
                    boolean isExpanded = control.isExpanded();
                    control.setValue(element);
                    if (!control.isCollapsible()) {
                        return;
                    }
                    if (isExpanded) {
                        if (oldSelectedElement == element) {
                            control.setExpanded(false);
                        } else {
                            control.setExpanded(true);
                        }
                    } else {
                        control.setExpanded(true);
                    }
                };
                node.addEventHandler(MouseEvent.MOUSE_CLICKED, clickHandler);
                node.getProperties().put((Object)CLICK_HANDLER, (Object)clickHandler);
                this.getChildren().add((Object)node);
                this.itemNodeMap.put(element, node);
            }
            this.getChildren().add((Object)this.arrowRegion);
        }

        protected void layoutChildren() {
            double w = this.getWidth();
            double h = this.getHeight();
            double arrowHeight = ((AvatarPane)AvatarPaneSkin.this.getSkinnable()).isExpanded() ? this.arrowRegion.prefHeight(-1.0) : 0.0;
            double avatarPrefWidth = 0.0;
            List avatars = this.getManagedChildren();
            int avatarCount = avatars.size();
            for (int i = 0; i < avatarCount; ++i) {
                avatarPrefWidth += ((Node)avatars.get(i)).prefWidth(-1.0);
            }
            double avatarPrefWidthWithDefaultSpacing = avatarPrefWidth + (double)avatarCount * 10.0;
            double avatarSpacing = 10.0;
            double xOffset = Math.max(0.0, (w - avatarPrefWidthWithDefaultSpacing) / 2.0);
            if (avatarPrefWidthWithDefaultSpacing >= w) {
                avatarSpacing = (w - avatarPrefWidth) / (double)(avatarCount - 1);
                xOffset = 0.0;
            }
            double x = xOffset;
            double y = 0.0;
            for (int i = 0; i < avatarCount; ++i) {
                Node avatarNode = (Node)avatars.get(i);
                double avatarWidth = avatarNode.prefWidth(-1.0);
                this.layoutInArea(avatarNode, this.snapPosition(x), this.snapPosition(y), this.snapSize(avatarWidth), this.snapSize(h - (arrowHeight + 5.0)), -1.0, HPos.CENTER, VPos.CENTER);
                x += avatarWidth + avatarSpacing;
            }
            if (((AvatarPane)AvatarPaneSkin.this.getSkinnable()).isExpanded()) {
                double arrowWidth = this.arrowRegion.prefWidth(-1.0);
                double arrowTargetX = this.findHeaderNodeMiddlePoint(AvatarPaneSkin.this.selectedHeader);
                double yShift = AvatarPaneSkin.this.frac == 0.0 ? arrowWidth : arrowWidth / 2.0;
                double arrowX = this.snapArrow ? arrowTargetX - yShift : (arrowTargetX - this.arrowStartX) * AvatarPaneSkin.this.frac + this.arrowStartX - yShift;
                this.arrowRegion.resizeRelocate(arrowX, h - arrowHeight, arrowWidth, arrowHeight);
            } else {
                this.arrowRegion.resize(0.0, 0.0);
            }
            this.snapArrow = false;
            if (this.firstDisplay) {
                this.firstDisplay = false;
                this.animateAvatars(true, null);
            }
        }

        protected double computePrefHeight(double width) {
            double avatarPrefHeight = 0.0;
            List avatars = this.getManagedChildren();
            int avatarCount = avatars.size();
            for (int i = 0; i < avatarCount; ++i) {
                avatarPrefHeight = Math.max(avatarPrefHeight, ((Node)avatars.get(i)).prefHeight(-1.0));
            }
            return avatarPrefHeight + this.arrowRegion.prefHeight(-1.0) + 5.0 + 10.0;
        }

        private double findHeaderNodeMiddlePoint(T element) {
            Node node = this.itemNodeMap.get(element);
            if (node == null) {
                return 0.0;
            }
            return node.getLayoutX() + node.getLayoutBounds().getWidth() / 2.0;
        }

        private void animateAvatars(boolean arriving, Runnable onComplete) {
            double w = this.getWidth();
            double delayStep = 40.0;
            double delay = 40.0;
            double animationDuration = arriving ? 700.0 : 350.0;
            ParallelTransition masterTransition = new ParallelTransition();
            List children = this.getManagedChildren();
            int max = this.getManagedChildren().size();
            for (int i = 0; i < max; ++i) {
                Node node = arriving ? (Node)children.get(i) : (Node)children.get(max - i - 1);
                TranslateTransition transition = AvatarPaneSkin.this.createTranslateAnimation(node, animationDuration, delay);
                delay += 40.0;
                if (arriving) {
                    node.setTranslateX(w);
                    transition.setByX(-w);
                } else {
                    transition.setByX(w);
                }
                masterTransition.getChildren().add((Object)transition);
            }
            if (!arriving) {
                TranslateTransition transition = AvatarPaneSkin.this.createTranslateAnimation((Node)this.arrowRegion, animationDuration, 0.0);
                transition.setByX(-(this.arrowRegion.getLayoutX() + this.arrowRegion.getWidth()));
                masterTransition.getChildren().add((Object)transition);
            }
            if (onComplete != null) {
                masterTransition.setOnFinished(e -> onComplete.run());
            }
            masterTransition.play();
        }
    }
}

