/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.Avatar;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Circle;

public class AvatarSkin
extends SkinBase<Avatar> {
    private final Circle clip = new Circle();
    private final Circle decoration = new Circle();
    private final ImageView imageView = new ImageView(){

        public double prefWidth(double height) {
            return ((Avatar)AvatarSkin.this.getSkinnable()).getRadius() * 2.0;
        }

        public double prefHeight(double width) {
            return ((Avatar)AvatarSkin.this.getSkinnable()).getRadius() * 2.0;
        }

        public double maxWidth(double height) {
            return ((Avatar)AvatarSkin.this.getSkinnable()).getRadius() * 2.0;
        }

        public double maxHeight(double width) {
            return ((Avatar)AvatarSkin.this.getSkinnable()).getRadius() * 2.0;
        }
    };
    private final DoubleBinding diameterBinding;
    final InvalidationListener imageInvalidationListener = o -> {
        final Image image = ((Avatar)this.getSkinnable()).getImage();
        if (image != null && image.isBackgroundLoading() && image.getProgress() < 1.0) {
            image.progressProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    if (image.getProgress() == 1.0) {
                        image.progressProperty().removeListener((InvalidationListener)this);
                        AvatarSkin.this.setupCorrectScaling();
                    }
                }
            });
        } else {
            this.setupCorrectScaling();
        }
    };

    public AvatarSkin(Avatar control) {
        super((Control)control);
        control.setClip((Node)this.clip);
        control.imageProperty().addListener(this.imageInvalidationListener);
        this.decoration.getStyleClass().add((Object)"decoration");
        this.getChildren().addAll((Object[])new Node[]{this.imageView, this.decoration});
        this.clip.radiusProperty().bind((ObservableValue)control.radiusProperty());
        this.clip.centerXProperty().bind((ObservableValue)this.clip.radiusProperty());
        this.clip.centerYProperty().bind((ObservableValue)this.clip.radiusProperty());
        this.decoration.radiusProperty().bind((ObservableValue)this.clip.radiusProperty().subtract((ObservableNumberValue)this.decoration.strokeWidthProperty().divide(2.0)));
        this.decoration.centerXProperty().bind((ObservableValue)this.clip.radiusProperty());
        this.decoration.centerYProperty().bind((ObservableValue)this.clip.radiusProperty());
        this.diameterBinding = this.clip.radiusProperty().multiply(2);
        this.imageView.setPreserveRatio(true);
        control.prefWidthProperty().bind((ObservableValue)this.diameterBinding);
        control.prefHeightProperty().bind((ObservableValue)this.diameterBinding);
        this.setupCorrectScaling();
    }

    public void dispose() {
        ((Avatar)this.getSkinnable()).imageProperty().removeListener(this.imageInvalidationListener);
        this.clip.radiusProperty().unbind();
        this.clip.centerXProperty().unbind();
        this.clip.centerYProperty().unbind();
        this.decoration.radiusProperty().unbind();
        this.decoration.centerXProperty().unbind();
        this.decoration.centerYProperty().unbind();
        ((Avatar)this.getSkinnable()).prefWidthProperty().unbind();
        ((Avatar)this.getSkinnable()).prefHeightProperty().unbind();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        for (Node node : this.getChildren()) {
            node.resizeRelocate(0.0, 0.0, w, h);
        }
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    private void setupCorrectScaling() {
        this.imageView.fitWidthProperty().unbind();
        this.imageView.fitHeightProperty().unbind();
        Image image = ((Avatar)this.getSkinnable()).getImage();
        if (image != null) {
            this.imageView.setImage(null);
            double imageWidth = image.getWidth();
            double imageHeight = image.getHeight();
            if (imageWidth < imageHeight) {
                this.imageView.fitWidthProperty().bind((ObservableValue)this.diameterBinding);
            } else {
                this.imageView.fitHeightProperty().bind((ObservableValue)this.diameterBinding);
            }
        }
        this.imageView.setImage(image);
        ((Avatar)this.getSkinnable()).requestLayout();
    }
}

