/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.BottomNavigation;
import com.gluonhq.charm.glisten.control.BottomNavigationButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;

public class BottomNavigationSkin
extends SkinBase<BottomNavigation> {
    private static final double SHIFTING_DELTA = 50.0;
    private static final double MAX_NODE_WIDTH = 168.0;
    private static final PseudoClass PSEUDO_CLASS_SHIFTING = PseudoClass.getPseudoClass((String)"shifting");
    private static Map<BottomNavigationButton, ChangeListener<Boolean>> buttonListenerMap = new HashMap<BottomNavigationButton, ChangeListener<Boolean>>();

    public BottomNavigationSkin(BottomNavigation control) {
        super((Control)control);
        this.getChildren().setAll(((BottomNavigation)this.getSkinnable()).getActionItems());
        this.addSelectionIfAbsent(control);
        this.initializeListener(control);
        this.updatePseudoClass(control);
    }

    protected void layoutChildren(double contentX, double contentY, double width, double height) {
        double currentX;
        double prefNodeWidth;
        ObservableList<BottomNavigationButton> actionItems = ((BottomNavigation)this.getSkinnable()).getActionItems();
        ArrayList<BottomNavigationButton> managedActionItems = new ArrayList<BottomNavigationButton>();
        boolean isShifting = ((BottomNavigation)this.getSkinnable()).getType() == BottomNavigation.Type.SHIFTING;
        double selectionDelta = isShifting ? 50.0 : 0.0;
        double effectiveHeight = ((BottomNavigation)this.getSkinnable()).prefHeight(width) - contentY - this.snappedBottomInset();
        double effectiveWidth = width - this.snappedLeftInset() - this.snappedRightInset();
        for (BottomNavigationButton actionItem : actionItems) {
            if (!actionItem.isManaged()) continue;
            managedActionItems.add(actionItem);
        }
        if (effectiveWidth < 168.0 * (double)managedActionItems.size()) {
            prefNodeWidth = (effectiveWidth - selectionDelta) / (double)(managedActionItems.isEmpty() ? 1 : managedActionItems.size());
            currentX = contentX;
        } else {
            prefNodeWidth = 168.0;
            currentX = contentX + (effectiveWidth - 168.0 * (double)managedActionItems.size()) / 2.0;
        }
        for (BottomNavigationButton button : managedActionItems) {
            double actualNodeWidth = prefNodeWidth;
            if (isShifting && button.isSelected()) {
                actualNodeWidth += selectionDelta;
            }
            button.resizeRelocate(currentX, contentY, actualNodeWidth, effectiveHeight);
            currentX += actualNodeWidth;
        }
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefHeight = 0.0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            prefHeight = Math.max(node.prefHeight(width), prefHeight);
        }
        return topInset + prefHeight + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefWidth = 0.0;
        double spacing = 10.0;
        for (Node node : this.getChildren()) {
            if (!node.isManaged()) continue;
            prefWidth += node.prefWidth(height) + spacing;
        }
        return leftInset + prefWidth + rightInset;
    }

    private void addSelectionIfAbsent(BottomNavigation control) {
        boolean selected = false;
        for (BottomNavigationButton button : control.getActionItems()) {
            if (!button.isSelected()) continue;
            selected = true;
            break;
        }
        if (!selected && control.getActionItems().size() > 0) {
            ((BottomNavigationButton)((Object)control.getActionItems().get(0))).setSelected(true);
        }
    }

    private void initializeListener(BottomNavigation control) {
        for (BottomNavigationButton button : control.getActionItems()) {
            this.addSelectionListener(button);
        }
        control.getActionItems().addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    this.getChildren().addAll((Collection)c.getAddedSubList());
                    for (BottomNavigationButton button : c.getAddedSubList()) {
                        this.addSelectionListener(button);
                    }
                    continue;
                }
                if (!c.wasRemoved()) continue;
                this.getChildren().removeAll((Collection)c.getRemoved());
                for (BottomNavigationButton button : c.getRemoved()) {
                    this.removeSelectionListener(button);
                }
            }
        });
        control.typeProperty().addListener((observable, oldValue, newValue) -> {
            this.updatePseudoClass(control);
            control.requestFocus();
        });
    }

    private void addSelectionListener(BottomNavigationButton bottomNavigationButton) {
        SelectionChangeListener changeListener = new SelectionChangeListener(bottomNavigationButton);
        bottomNavigationButton.selectedProperty().addListener((ChangeListener)changeListener);
        buttonListenerMap.put(bottomNavigationButton, changeListener);
    }

    private void removeSelectionListener(BottomNavigationButton bottomNavigationButton) {
        ChangeListener<Boolean> changeListener = buttonListenerMap.get((Object)bottomNavigationButton);
        if (changeListener != null) {
            bottomNavigationButton.selectedProperty().removeListener(changeListener);
        }
        buttonListenerMap.remove((Object)bottomNavigationButton);
    }

    private void updatePseudoClass(BottomNavigation control) {
        control.pseudoClassStateChanged(PSEUDO_CLASS_SHIFTING, control.getType() == BottomNavigation.Type.SHIFTING);
    }

    private class SelectionChangeListener
    implements ChangeListener<Boolean> {
        private BottomNavigationButton button;

        SelectionChangeListener(BottomNavigationButton button) {
            this.button = button;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                for (BottomNavigationButton node : ((BottomNavigation)BottomNavigationSkin.this.getSkinnable()).getActionItems()) {
                    if (((Object)((Object)node)).equals((Object)this.button)) continue;
                    node.setSelected(false);
                }
            }
        }
    }
}

