/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.CardCell;
import com.gluonhq.charm.glisten.control.CardPane;
import com.gluonhq.charm.glisten.control.CharmListCell;
import com.gluonhq.charm.glisten.control.CharmListView;
import com.gluonhq.charm.glisten.control.skin.CharmListViewSkin;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;

public class CardPaneSkin<T>
extends SkinBase<CardPane<T>> {
    private CharmListView<T, ?> listView = new CharmListView();
    private CharmListViewSkin.CharmVirtualFlow flow;

    public CardPaneSkin(CardPane<T> control) {
        super(control);
        this.listView.setCellFactory(param -> new OuterCell());
        this.listView.onPullToRefreshProperty().bind(control.onPullToRefreshProperty());
        Bindings.bindContent(this.listView.itemsProperty(), control.getItems());
        this.listView.placeholderProperty().bind(control.placeholderProperty());
        this.getChildren().add(this.listView);
        InvalidationListener skinListener = new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (CardPaneSkin.this.listView.getSkin() != null) {
                    CardPaneSkin.this.listView.skinProperty().removeListener((InvalidationListener)this);
                    CardPaneSkin.this.flow = ((CharmListViewSkin)CardPaneSkin.this.listView.getSkin()).getVirtualFlow();
                }
            }
        };
        this.listView.skinProperty().addListener(skinListener);
        control.cellFactoryProperty().addListener((obs, c, c1) -> {
            this.flow.recreateCells();
            control.requestLayout();
        });
    }

    private class OuterCell<T>
    extends CharmListCell<T> {
        CardCell<T> cardCell;

        public OuterCell() {
            this.getStyleClass().add((Object)"outer-cell");
            CardPane cardPane = (CardPane)CardPaneSkin.this.getSkinnable();
            this.cardCell = (CardCell)((Object)cardPane.getCellFactory().call((Object)cardPane));
            this.setGraphic((Node)this.cardCell);
            this.setText(null);
        }

        @Override
        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            this.cardCell.updateItem(item, empty);
        }
    }
}

