/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.attach.util.Platform;
import com.gluonhq.charm.glisten.control.CharmListCell;
import com.gluonhq.charm.glisten.control.CharmListView;
import com.gluonhq.impl.charm.glisten.control.RefreshIndicator;
import com.gluonhq.impl.charm.glisten.control.skin.util.HeadersList;
import com.gluonhq.impl.charm.glisten.util.GlistenSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.concurrent.Task;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.ListViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.shape.Rectangle;

public class CharmListViewSkin<T, K extends Comparable>
extends SkinBase<CharmListView<T, K>> {
    public static final String RECREATE = "listRecreateKey";
    private static final double START_REFRESH_POSITION = 35.0;
    private static final double END_PULL_POSITION = 55.0;
    private static final double TOLERANCE = 10.0;
    private static final List<String> COMMON_CELL_PSEUDO_CLASSES = Arrays.asList("odd", "even", "selected", "focused", "empty", "filled");
    private double pullPosition;
    private boolean touchPressedOnTop;
    private boolean updatingItem;
    private double pressPoint = -1.0;
    private RefreshIndicator refreshIndicator;
    private PullToRefreshTouchPressed pullToRefreshTouchPressed;
    private PullToRefreshTouchReleased pullToRefreshTouchReleased;
    boolean needCellsRecreated = true;
    private EventDispatcher flowEventDispatcher;
    private HeadersList<T, K> headersList;
    private BitSet headersIndex;
    private CharmVirtualFlow flow;
    private ScrollBar scrollbar;
    private CharmListCell<T> floatingHeaderCell;
    private final CharmListView<T, K> charmListView;
    private final ListView<T> listView = new ListView();
    private final DoubleProperty scrollbarWidth = new SimpleDoubleProperty();
    private final BooleanProperty floatingHeaderVisible = new SimpleBooleanProperty();
    private final IntegerProperty floatingHeaderIndex = new SimpleIntegerProperty(-1);
    private final BooleanProperty topCellHeader = new SimpleBooleanProperty();
    private final IntegerProperty topCellIndex = new SimpleIntegerProperty(-1);
    private final DoubleProperty topCellPosition = new SimpleDoubleProperty();
    private final Label floatingHeader;
    private EventHandler<ScrollEvent> scrollListener = event -> {
        double delta = event.getDeltaY();
        if (this.touchPressedOnTop && (delta > 0.0 || this.pullPosition > 0.0) && !((CharmListView)this.getSkinnable()).isRefreshIndicatorVisible()) {
            if (this.refreshIndicator == null) {
                this.refreshIndicator = new RefreshIndicator();
                this.getChildren().add((Object)this.refreshIndicator);
            }
            this.refreshIndicator.setVisible(true);
            this.refreshIndicator.setMode(RefreshIndicator.Mode.PULLING);
            double rateOfTranslation = this.pullPosition < 35.0 ? 0.4 : 0.2;
            this.pullPosition += delta * rateOfTranslation;
            if (this.pullPosition > 55.0) {
                this.pullPosition = 55.0;
            }
            this.refreshIndicator.setPullProgress(this.pullPosition / 35.0);
            this.refreshIndicator.setLayoutY(this.pullPosition);
            if (this.pullPosition < 0.0 && this.refreshIndicator != null) {
                this.refreshIndicator.setVisible(false);
            }
        }
    };
    private EventDispatcher pullToRefreshEventDispatcher = (event, tail) -> {
        if (event instanceof ScrollEvent) {
            this.scrollListener.handle((Event)((ScrollEvent)event));
        } else if (event instanceof TouchEvent) {
            TouchEvent touchEvent = (TouchEvent)event;
            if (touchEvent.getEventType().equals(TouchEvent.TOUCH_RELEASED)) {
                this.pullToRefreshTouchReleased.handle(touchEvent);
            } else if (touchEvent.getEventType().equals(TouchEvent.TOUCH_PRESSED)) {
                this.pullToRefreshTouchPressed.handle(touchEvent);
            }
        }
        return null;
    };
    private final ListChangeListener<T> listChangeListener = c -> {
        this.resetIndices();
        this.updateHeadersList();
    };
    private final MapChangeListener<Object, Object> propertiesMapListener = c -> {
        if (!c.wasAdded()) {
            return;
        }
        if (RECREATE.equals(c.getKey())) {
            this.needCellsRecreated = true;
            this.listView.refresh();
            ((CharmListView)this.getSkinnable()).requestLayout();
            ((CharmListView)this.getSkinnable()).getProperties().remove((Object)RECREATE);
        }
    };

    public CharmListViewSkin(final CharmListView<T, K> charmListView) {
        super(charmListView);
        this.charmListView = charmListView;
        this.listView.setFocusTraversable(false);
        this.listView.sceneProperty().addListener((obs, ov, nv) -> {
            if (nv != null && this.flow != null) {
                this.flow.recreateCells();
            }
        });
        this.headersList = (HeadersList)charmListView.getHeadersList();
        this.listView.setItems(this.headersList);
        this.headersIndex = this.headersList.getHeadersIndex();
        this.listView.setPlaceholder(charmListView.getPlaceholder());
        this.listView.setCellFactory(p -> {
            ListCell cell = new ListCell<T>(){
                private boolean isHeader;
                CharmListCell currentCell;
                CharmListCell regularCell;
                CharmListCell headerCell;
                private final List DEFAULT = this.getStyleClass();

                protected void updateItem(T item, boolean empty) {
                    super.updateItem(item, empty);
                    this.applyPseudoClasses(false);
                    if (item != null && !empty) {
                        this.isHeader = CharmListViewSkin.this.headersIndex.get(this.getIndex());
                        this.currentCell = this.isHeader ? this.getHeaderCell() : this.getRegularCell();
                        this.currentCell.updateIndex(this.getIndex());
                        this.currentCell.updateItem(item, empty);
                        this.setGraphicTextGap(this.currentCell.getGraphicTextGap());
                        this.setText(this.currentCell.getText());
                        this.setGraphic(this.currentCell.getGraphic());
                        this.setStyle(this.currentCell.getStyle());
                        this.setStyleClasses(this.isHeader);
                        this.setMinHeight(Math.max(this.currentCell.getMinHeight(), 1.0));
                    } else {
                        this.setText(null);
                        this.setGraphic(null);
                        this.setStyle(null);
                        this.getStyleClass().setAll((Collection)this.DEFAULT);
                        this.setMinHeight(0.0);
                    }
                    this.applyPseudoClasses(true);
                }

                private CharmListCell<T> getHeaderCell() {
                    if (this.headerCell == null) {
                        this.headerCell = ((CharmListView)CharmListViewSkin.this.getSkinnable()).getHeaderCellFactory() != null ? (CharmListCell)((Object)((CharmListView)CharmListViewSkin.this.getSkinnable()).getHeaderCellFactory().call((Object)charmListView)) : CharmListViewSkin.this.createDefaultCellImpl(true);
                    }
                    return this.headerCell;
                }

                private CharmListCell<T> getRegularCell() {
                    if (this.regularCell == null) {
                        this.regularCell = ((CharmListView)CharmListViewSkin.this.getSkinnable()).getCellFactory() != null ? (CharmListCell)((Object)((CharmListView)CharmListViewSkin.this.getSkinnable()).getCellFactory().call((Object)charmListView)) : CharmListViewSkin.this.createDefaultCellImpl(false);
                    }
                    return this.regularCell;
                }

                private void setStyleClasses(boolean isHeader) {
                    ArrayList<String> newStyles = new ArrayList<String>((Collection<String>)this.currentCell.getStyleClass());
                    newStyles.add(isHeader ? "header-cell" : "regular-cell");
                    if (!CharmListViewSkin.sameStyles((List<String>)this.getStyleClass(), newStyles)) {
                        this.getStyleClass().setAll(newStyles);
                    }
                }

                private void applyPseudoClasses(boolean active) {
                    if (this.currentCell != null) {
                        ObservableSet pseudoClassStates = this.currentCell.getPseudoClassStates();
                        for (PseudoClass next : pseudoClassStates) {
                            if (COMMON_CELL_PSEUDO_CLASSES.contains(next.getPseudoClassName())) continue;
                            this.pseudoClassStateChanged(next, active);
                        }
                    }
                }
            };
            if (GlistenSettings.isExperimentalPerformance()) {
                cell.setCache(true);
            }
            return cell;
        });
        if (charmListView.getSelectedItem() != null) {
            this.selectItem(charmListView.getSelectedItem());
        }
        charmListView.selectedItemProperty().addListener((observable, oldValue, newValue) -> this.selectItem(newValue));
        this.listView.setSkin((Skin)new ListViewSkin<T>(this.listView){

            protected VirtualFlow<ListCell<T>> createVirtualFlow() {
                CharmListViewSkin.this.flow = new CharmVirtualFlow();
                CharmListViewSkin.this.scrollbar = CharmListViewSkin.this.flow.getScrollBar();
                if (Platform.isDesktop()) {
                    CharmListViewSkin.this.scrollbarWidth.bind((ObservableValue)CharmListViewSkin.this.scrollbar.widthProperty());
                }
                CharmListViewSkin.this.scrollbar.valueProperty().addListener(o -> CharmListViewSkin.this.floatingHeaderVisible.set(CharmListViewSkin.this.enableFloatingHeader()));
                CharmListViewSkin.this.setupPullToRefresh();
                CharmListViewSkin.this.installListeners();
                return CharmListViewSkin.this.flow;
            }
        });
        this.getChildren().add(this.listView);
        this.floatingHeader = new Label();
        this.floatingHeader.setPrefWidth(Double.MAX_VALUE);
        this.floatingHeader.getStyleClass().addAll((Object[])new String[]{"floating-header", "list-cell", "header-cell"});
        if (charmListView.getHeadersFunction() != null) {
            this.floatingHeaderCell = ((CharmListView)this.getSkinnable()).getHeaderCellFactory() != null ? (CharmListCell)((Object)((CharmListView)this.getSkinnable()).getHeaderCellFactory().call(charmListView)) : this.createDefaultCellImpl(true);
            this.floatingHeaderIndex.addListener((obs, i, i1) -> {
                if (i1.intValue() > -1) {
                    this.updateFloatingHeader(i1.intValue());
                }
            });
            this.floatingHeader.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)charmListView.floatingHeaderVisibleProperty(), (ObservableBooleanValue)this.floatingHeaderVisible));
            PseudoClass pseudoClass = PseudoClass.getPseudoClass((String)"snapped");
            this.floatingHeader.translateYProperty().addListener((obs, n, n1) -> this.floatingHeader.pseudoClassStateChanged(pseudoClass, n1.doubleValue() < 0.0));
            Rectangle clipHeader = new Rectangle();
            clipHeader.widthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.listView.getWidth() - this.scrollbarWidth.get() - this.listView.getPadding().getLeft() - this.listView.getPadding().getRight(), (Observable[])new Observable[]{this.listView.widthProperty(), this.scrollbarWidth, this.listView.paddingProperty()}));
            clipHeader.heightProperty().bind((ObservableValue)this.floatingHeader.heightProperty().add(10));
            this.floatingHeader.setClip((Node)clipHeader);
            this.floatingHeader.translateYProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.topCellHeader.and((ObservableBooleanValue)this.topCellPosition.lessThan((ObservableNumberValue)this.floatingHeader.heightProperty()))).then((ObservableNumberValue)this.topCellPosition.subtract((ObservableNumberValue)this.floatingHeader.heightProperty())).otherwise(0));
            this.getChildren().add((Object)this.floatingHeader);
        }
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)charmListView.widthProperty());
        clip.heightProperty().bind((ObservableValue)charmListView.heightProperty());
        charmListView.setClip((Node)clip);
        this.listView.setOnMousePressed(e -> {
            this.pressPoint = e.getScreenY();
        });
        this.listView.addEventFilter(MouseEvent.ANY, event -> {
            if (event.getEventType().equals(MouseEvent.MOUSE_RELEASED) || event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                if (this.pressPoint != -1.0 && Math.abs(event.getScreenY() - this.pressPoint) >= 10.0) {
                    event.consume();
                    if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                        this.pressPoint = -1.0;
                    }
                } else {
                    this.pressPoint = -1.0;
                    int index = this.listView.getSelectionModel().getSelectedIndex();
                    if (index > -1) {
                        this.selectIndex(index);
                    } else {
                        this.listView.getSelectionModel().selectedIndexProperty().addListener(new InvalidationListener(){

                            public void invalidated(Observable observable) {
                                int index = CharmListViewSkin.this.listView.getSelectionModel().getSelectedIndex();
                                if (index > -1) {
                                    CharmListViewSkin.this.selectIndex(index);
                                    CharmListViewSkin.this.listView.getSelectionModel().selectedIndexProperty().removeListener((InvalidationListener)this);
                                }
                            }
                        });
                    }
                }
            }
        });
        ObservableMap properties = charmListView.getProperties();
        properties.remove((Object)RECREATE);
        properties.addListener(this.propertiesMapListener);
    }

    public void scrollTo(int previousSetBit) {
        this.listView.scrollTo(previousSetBit);
    }

    private static boolean sameStyles(List<String> lst1, List<String> lst2) {
        return lst1 != null && lst2 != null && lst1.size() == lst2.size() && lst1.containsAll(lst2);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        if (this.needCellsRecreated) {
            this.flow.recreateCells();
            this.needCellsRecreated = false;
        }
        this.layoutInArea((Node)this.listView, contentX, contentY, contentWidth, contentHeight, -1.0, HPos.CENTER, VPos.CENTER);
        this.layoutInArea((Node)this.floatingHeader, contentX + this.listView.getPadding().getLeft(), contentY + this.listView.getPadding().getTop(), contentWidth - this.scrollbarWidth.get() - this.listView.getPadding().getRight() - this.listView.getPadding().getLeft(), contentHeight, -1.0, HPos.CENTER, VPos.TOP);
        if (this.refreshIndicator != null) {
            this.refreshIndicator.setLayoutX(this.snapPositionX(contentWidth / 2.0));
        }
    }

    private void installListeners() {
        this.headersList.addListener(this.listChangeListener);
        this.charmListView.itemsProperty().addListener((obs, c, c1) -> {
            this.resetIndices();
            this.updateHeadersList();
        });
        this.charmListView.headersFunctionProperty().addListener((obs, c, c1) -> {
            this.resetIndices();
            this.updateHeadersList();
        });
        this.charmListView.comparatorProperty().addListener((obs, c, c1) -> {
            this.resetIndices();
            this.updateHeadersList();
        });
        this.charmListView.headersComparatorProperty().addListener((obs, c, c1) -> {
            this.resetIndices();
            this.updateHeadersList();
        });
        this.charmListView.cellFactoryProperty().addListener((obs, c, c1) -> {
            this.flow.recreateCells();
            this.charmListView.requestLayout();
        });
        this.charmListView.cellHeaderFactoryProperty().addListener((obs, c, c1) -> {
            this.flow.recreateCells();
            this.floatingHeaderCell = (CharmListCell)((Object)((Object)c1.call(this.charmListView)));
            this.charmListView.requestLayout();
            this.updateFloatingHeader(this.topCellIndex.get());
        });
        this.charmListView.placeholderProperty().addListener((obs, n, n1) -> this.listView.setPlaceholder(n1));
    }

    private void setupPullToRefresh() {
        this.flowEventDispatcher = this.flow.getEventDispatcher();
        this.pullToRefreshTouchPressed = new PullToRefreshTouchPressed();
        this.pullToRefreshTouchReleased = new PullToRefreshTouchReleased();
        this.touchPressedOnTop = false;
        CharmListView charmListView = (CharmListView)this.getSkinnable();
        charmListView.onPullToRefreshProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue == null && newValue != null) {
                this.flow.addEventFilter(ScrollEvent.SCROLL, this.scrollListener);
                this.flow.addEventFilter(TouchEvent.TOUCH_RELEASED, this.pullToRefreshTouchReleased);
                this.flow.addEventFilter(TouchEvent.TOUCH_PRESSED, this.pullToRefreshTouchPressed);
            } else if (oldValue != null && newValue == null) {
                this.flow.removeEventFilter(ScrollEvent.SCROLL, this.scrollListener);
                this.flow.removeEventFilter(TouchEvent.TOUCH_RELEASED, this.pullToRefreshTouchReleased);
                this.flow.removeEventFilter(TouchEvent.TOUCH_PRESSED, this.pullToRefreshTouchPressed);
            }
        });
        if (charmListView.getOnPullToRefresh() != null) {
            this.flow.addEventFilter(ScrollEvent.SCROLL, this.scrollListener);
            this.flow.addEventFilter(TouchEvent.TOUCH_RELEASED, this.pullToRefreshTouchReleased);
            this.flow.addEventFilter(TouchEvent.TOUCH_PRESSED, this.pullToRefreshTouchPressed);
        }
        charmListView.refreshIndicatorVisibleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.showRefreshIndicatorRefreshing();
            } else {
                this.getChildren().remove((Object)this.refreshIndicator);
                this.refreshIndicator = null;
                this.pullPosition = 0.0;
            }
        });
        if (charmListView.isRefreshIndicatorVisible()) {
            this.showRefreshIndicatorRefreshing();
        }
    }

    private void showRefreshIndicatorRefreshing() {
        if (this.refreshIndicator == null) {
            this.refreshIndicator = new RefreshIndicator();
            this.getChildren().add((Object)this.refreshIndicator);
        }
        this.pullPosition = 35.0;
        this.refreshIndicator.setMode(RefreshIndicator.Mode.REFRESHING);
        this.refreshIndicator.setLayoutY(this.pullPosition);
        ((CharmListView)this.getSkinnable()).requestLayout();
    }

    private boolean isPullToRefreshEnabled() {
        return ((CharmListView)this.getSkinnable()).getOnPullToRefresh() != null;
    }

    private void resetIndices() {
        this.floatingHeaderVisible.set(false);
        this.floatingHeaderIndex.set(-1);
        this.topCellHeader.set(false);
        this.topCellIndex.set(-1);
        this.floatingHeaderIndex.set(-1);
    }

    private void updateHeadersList() {
        if (this.headersList != null) {
            this.headersList.removeListener(this.listChangeListener);
        }
        this.headersList = (HeadersList)this.charmListView.getHeadersList();
        this.headersIndex = this.headersList.getHeadersIndex();
        this.listView.setItems(this.headersList);
        this.charmListView.requestLayout();
        this.floatingHeaderVisible.set(this.enableFloatingHeader());
        this.headersList.addListener(this.listChangeListener);
    }

    private boolean enableFloatingHeader() {
        ListCell cell = this.flow.getFirstVisibleCellWithinViewport();
        if (cell != null) {
            if (this.topCellIndex.get() != cell.getIndex()) {
                this.topCellHeader.set(this.headersIndex.get(cell.getIndex()));
                if (this.topCellPosition.isBound()) {
                    this.topCellPosition.unbind();
                }
                this.topCellPosition.bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.topCellHeader).then((ObservableNumberValue)cell.layoutYProperty()).otherwise(0));
                int index = this.headersIndex.previousSetBit(cell.getIndex() - (this.topCellHeader.getValue() != false ? 1 : 0));
                if (index > -1) {
                    this.floatingHeaderIndex.set(index);
                }
                this.topCellIndex.set(cell.getIndex());
            }
            return this.topCellIndex.get() > 0;
        }
        return false;
    }

    private void updateFloatingHeader(int index) {
        if (index > -1) {
            this.floatingHeaderCell.updateItem(this.headersList.get(index), false);
        }
        this.floatingHeader.setGraphic(this.floatingHeaderCell.getGraphic());
        this.floatingHeader.setText(this.floatingHeaderCell.getText());
        this.floatingHeader.setGraphicTextGap(this.floatingHeaderCell.getGraphicTextGap());
    }

    private CharmListCell<T> createDefaultCellImpl(final boolean isHeader) {
        return new CharmListCell<T>(){

            @Override
            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof Node) {
                    this.setText(null);
                    this.setGraphic((Node)item);
                } else {
                    this.setText(item == null ? "" : (!isHeader ? item.toString() : ((CharmListView)CharmListViewSkin.this.getSkinnable()).toString(item)));
                    this.setGraphic(null);
                }
            }
        };
    }

    private void startPullToRefresh() {
        this.pullPosition = 0.0;
        this.touchPressedOnTop = true;
        this.flow.setEventDispatcher(this.pullToRefreshEventDispatcher);
    }

    private void stopPullToRefresh() {
        this.getChildren().remove((Object)this.refreshIndicator);
        this.refreshIndicator = null;
        this.touchPressedOnTop = false;
        if (this.pullPosition >= 35.0 && this.isPullToRefreshEnabled()) {
            Task task = new Task(){

                protected Object call() throws Exception {
                    CharmListViewSkin.this.charmListView.getOnPullToRefresh().handle((Event)new ActionEvent(CharmListViewSkin.this.listView, CharmListViewSkin.this.listView));
                    javafx.application.Platform.runLater(() -> CharmListViewSkin.this.charmListView.setRefreshIndicatorVisible(false));
                    return null;
                }
            };
            Thread thread = new Thread((Runnable)task);
            thread.setDaemon(true);
            this.charmListView.setRefreshIndicatorVisible(true);
            thread.start();
        }
        this.flow.setEventDispatcher(this.flowEventDispatcher);
    }

    private void selectItem(T item) {
        if (this.updatingItem) {
            return;
        }
        this.updatingItem = true;
        if (item == null) {
            this.listView.getSelectionModel().clearSelection();
        } else {
            for (int index = 0; index < this.listView.getItems().size(); ++index) {
                if (!item.equals(this.listView.getItems().get(index))) continue;
                boolean isHeader = this.headersIndex.get(index);
                if (isHeader) {
                    this.listView.getSelectionModel().select(++index);
                    break;
                }
                this.listView.getSelectionModel().select(index);
                break;
            }
        }
        this.updatingItem = false;
    }

    private void selectIndex(int index) {
        boolean isHeader = this.headersIndex.get(index);
        if (!isHeader) {
            this.updatingItem = true;
            this.charmListView.setSelectedItem(this.listView.getSelectionModel().getSelectedItem());
            this.updatingItem = false;
        }
    }

    protected final CharmVirtualFlow getVirtualFlow() {
        return this.flow;
    }

    public class CharmVirtualFlow
    extends VirtualFlow<ListCell<T>> {
        protected ListCell<T> getFirstVisibleCellWithinViewport() {
            return (ListCell)super.getFirstVisibleCellWithinViewport();
        }

        protected void recreateCells() {
            super.recreateCells();
        }

        public ScrollBar getScrollBar() {
            return super.getVbar();
        }
    }

    private class PullToRefreshTouchPressed
    implements EventHandler<TouchEvent> {
        private PullToRefreshTouchPressed() {
        }

        public void handle(TouchEvent event) {
            if (CharmListViewSkin.this.isPullToRefreshEnabled() && !CharmListViewSkin.this.charmListView.isRefreshIndicatorVisible() && CharmListViewSkin.this.flow.getPosition() == 0.0) {
                CharmListViewSkin.this.startPullToRefresh();
            }
        }
    }

    private class PullToRefreshTouchReleased
    implements EventHandler<TouchEvent> {
        private PullToRefreshTouchReleased() {
        }

        public void handle(TouchEvent event) {
            if (CharmListViewSkin.this.isPullToRefreshEnabled() && !CharmListViewSkin.this.charmListView.isRefreshIndicatorVisible()) {
                CharmListViewSkin.this.stopPullToRefresh();
            }
        }
    }
}

