/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.Avatar;
import com.gluonhq.charm.glisten.control.Chip;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;

public class ChipSkin
extends SkinBase<Chip> {
    private final StackPane crossContainer;
    private final Label cross = new Label();
    private final Label label = new Label();
    private Avatar avatar;

    public ChipSkin(Chip control) {
        super((Control)control);
        this.crossContainer = new StackPane();
        this.avatar = new Avatar();
        this.label.textProperty().bind((ObservableValue)control.textProperty());
        this.crossContainer.getChildren().add((Object)this.cross);
        if (control.getGraphic() != null) {
            this.avatar.setImage(control.getGraphic());
            this.getChildren().add((Object)this.avatar);
        }
        this.getChildren().add((Object)this.label);
        if (control.isDeletable()) {
            this.getChildren().add((Object)this.crossContainer);
        }
        this.crossContainer.getStyleClass().add((Object)"cross-container");
        this.cross.getStyleClass().add((Object)"cross");
        this.cross.setOnMousePressed(event -> {
            EventHandler<ActionEvent> deleteAction = control.getOnDeleteAction();
            if (deleteAction != null) {
                ActionEvent actionEvent = new ActionEvent((Object)this.getSkinnable(), null);
                deleteAction.handle((Event)actionEvent);
            }
        });
        control.deletableProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.getChildren().add((Object)this.crossContainer);
            } else {
                this.getChildren().remove((Object)this.crossContainer);
            }
        });
        control.graphicProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.avatar.setImage((Image)newValue);
                if (!this.getChildren().contains((Object)this.avatar)) {
                    this.getChildren().add((Object)this.avatar);
                }
            } else {
                this.getChildren().remove((Object)this.avatar);
            }
        });
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        Chip control = (Chip)this.getSkinnable();
        double currPosX = contentX;
        if (control.getGraphic() != null) {
            this.avatar.setLayoutX(currPosX);
            this.avatar.setLayoutY(contentY);
            currPosX += this.snapPosition(this.avatar.prefWidth(-1.0));
        }
        this.label.setLayoutX(currPosX);
        this.label.setLayoutY(this.snapPosition(contentY + contentHeight / 2.0 - this.label.prefHeight(-1.0) / 2.0));
        this.label.resize(this.snapSize(this.label.prefWidth(-1.0)), this.snapSize(this.label.prefHeight(-1.0)));
        currPosX += this.snapPosition(this.label.prefWidth(-1.0));
        if (control.isDeletable()) {
            this.crossContainer.setLayoutX(currPosX);
            this.crossContainer.setLayoutY(this.snapPosition(contentY + contentHeight / 2.0 - this.crossContainer.prefHeight(-1.0) / 2.0));
            this.cross.resize(this.snapSize(this.cross.prefWidth(-1.0)), this.snapSize(this.cross.prefHeight(-1.0)));
            this.crossContainer.resize(this.snapSize(this.crossContainer.prefWidth(-1.0)), this.snapSize(this.crossContainer.prefHeight(-1.0)));
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Chip control = (Chip)this.getSkinnable();
        if (!control.isDeletable() && control.getGraphic() == null) {
            return leftInset + this.label.prefWidth(-1.0) + rightInset;
        }
        if (control.isDeletable() && control.getGraphic() == null) {
            return leftInset + this.label.prefWidth(-1.0) + this.crossContainer.prefWidth(-1.0) + rightInset;
        }
        return leftInset + this.avatar.prefWidth(-1.0) + this.label.prefWidth(-1.0) + this.crossContainer.prefWidth(-1.0) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Chip control = (Chip)this.getSkinnable();
        double maxHeight = this.label.prefHeight(-1.0);
        if (control.isDeletable() && control.getGraphic() == null) {
            maxHeight = Math.max(this.crossContainer.prefHeight(-1.0), maxHeight);
        } else if (control.isDeletable() && control.getGraphic() != null) {
            maxHeight = Math.max(this.crossContainer.prefHeight(-1.0), maxHeight);
            maxHeight = Math.max(this.avatar.prefHeight(-1.0), maxHeight);
        }
        return topInset + maxHeight + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ChipSkin.getClassCssMetaData();
    }
}

