/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.DropdownButton;
import com.gluonhq.charm.glisten.layout.layer.MenuPopupView;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;

public class DropdownButtonSkin
extends SkinBase<DropdownButton> {
    private final Menu menu;
    private final HBox container;
    private final Label text;
    private final Region arrow;
    private final MenuPopupView menuPopupView;
    private final HashMap<MenuItem, EventHandler<ActionEvent>> menuItemToListener = new HashMap();

    public DropdownButtonSkin(DropdownButton control) {
        super((Control)control);
        this.text = new Label();
        this.arrow = new Region();
        this.container = new HBox();
        this.menu = new Menu();
        this.menuPopupView = new MenuPopupView((Node)this.container, this.menu){

            @Override
            protected boolean useContentSize() {
                return false;
            }
        };
        this.container.getStyleClass().add((Object)"container");
        this.arrow.getStyleClass().add((Object)"arrow");
        this.addMenuItems((List<? extends MenuItem>)((DropdownButton)this.getSkinnable()).getItems());
        control.getItems().addListener(this::menuItemsChanged);
        this.container.setAlignment(Pos.CENTER);
        this.container.getChildren().addAll((Object[])new Node[]{this.text, this.arrow});
        this.getChildren().add((Object)this.container);
        if (control.getSelectedItem() != null) {
            this.setSelectedItem(control.getSelectedItem());
        }
        control.selectedItemProperty().addListener((obs, ov, nv) -> this.setSelectedItem(control.getSelectedItem()));
        this.container.setOnMousePressed(event -> this.onMousePressedOnDropDownButton());
    }

    private void onMousePressedOnDropDownButton() {
        this.menuPopupView.setPrefWidth(this.container.getBoundsInLocal().getWidth());
        this.menuPopupView.show();
    }

    private void menuItemsChanged(ListChangeListener.Change<? extends MenuItem> changed) {
        while (changed.next()) {
            if (changed.wasAdded()) {
                this.addMenuItems(changed.getAddedSubList());
            }
            if (!changed.wasRemoved()) continue;
            this.menu.getItems().removeAll((Collection)changed.getRemoved());
            for (MenuItem menuItem : changed.getRemoved()) {
                EventHandler<ActionEvent> eventHandler = this.menuItemToListener.get(menuItem);
                menuItem.removeEventHandler(ActionEvent.ACTION, eventHandler);
                this.menuItemToListener.remove(menuItem);
            }
        }
    }

    private void addMenuItems(List<? extends MenuItem> items) {
        if (items.isEmpty()) {
            return;
        }
        this.menu.getItems().addAll(items);
        for (MenuItem menuItem : items) {
            EventHandler eventHandler = e -> ((DropdownButton)this.getSkinnable()).setSelectedItem(menuItem);
            menuItem.addEventHandler(ActionEvent.ACTION, eventHandler);
            this.menuItemToListener.put(menuItem, (EventHandler<ActionEvent>)eventHandler);
        }
        MenuItem selectedItem = ((DropdownButton)this.getSkinnable()).getSelectedItem();
        if (selectedItem == null) {
            ((DropdownButton)this.getSkinnable()).setSelectedItem((MenuItem)this.menu.getItems().get(0));
        }
    }

    private void setSelectedItem(MenuItem menuItem) {
        this.text.setText(menuItem.getText());
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + this.container.prefWidth(height) + rightInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.container.prefHeight(width) + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

