/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.ExpansionPanel;
import com.gluonhq.charm.glisten.control.ExpansionPanelContainer;
import java.util.HashMap;
import javafx.animation.Transition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class ExpansionPanelContainerSkin
extends SkinBase<ExpansionPanelContainer> {
    private static final double CARD_GAP = 20.0;
    private static final Duration ANIMATION_DURATION = Duration.millis((double)350.0);
    private Container container = new Container();

    public ExpansionPanelContainerSkin(ExpansionPanelContainer control) {
        super((Control)control);
        this.getChildren().add((Object)this.container);
        control.getItems().addListener(c -> this.refreshContainer());
        this.refreshContainer();
        this.container.getStyleClass().add((Object)"container");
    }

    private void refreshContainer() {
        this.container.getChildren().clear();
        ObservableList<ExpansionPanel> items = ((ExpansionPanelContainer)this.getSkinnable()).getItems();
        for (int i = 0; i < items.size(); ++i) {
            if (i > 0) {
                this.container.getChildren().add((Object)this.createSeparator());
            }
            this.container.getChildren().add((Object)((Node)items.get(i)));
        }
    }

    private Separator createSeparator() {
        Separator separator = new Separator(Orientation.HORIZONTAL);
        separator.setPrefHeight(1.0);
        return separator;
    }

    private class Container
    extends Region {
        private boolean expandAnimation;
        private double animationFrac = 1.0;
        private ExpansionPanel animatedPanel;
        private HashMap<ExpansionPanel, ExpandListener> expansionPanelListeners = new HashMap();

        public Container() {
            ((ExpansionPanelContainer)ExpansionPanelContainerSkin.this.getSkinnable()).getItems().addListener(c -> {
                while (c.next()) {
                    if (c.wasAdded()) {
                        for (ExpansionPanel expansionPanel : c.getAddedSubList()) {
                            ExpandListener expandListener = new ExpandListener(expansionPanel);
                            expansionPanel.expandedProperty().addListener((ChangeListener)expandListener);
                            this.expansionPanelListeners.put(expansionPanel, expandListener);
                        }
                    }
                    if (!c.wasRemoved()) continue;
                    for (ExpansionPanel expansionPanel : c.getRemoved()) {
                        expansionPanel.expandedProperty().removeListener((ChangeListener)this.expansionPanelListeners.remove((Object)expansionPanel));
                    }
                }
            });
            for (ExpansionPanel expansionPanel : ((ExpansionPanelContainer)ExpansionPanelContainerSkin.this.getSkinnable()).getItems()) {
                ExpandListener expandListener = new ExpandListener(expansionPanel);
                expansionPanel.expandedProperty().addListener((ChangeListener)expandListener);
                this.expansionPanelListeners.put(expansionPanel, expandListener);
            }
        }

        public ObservableList<Node> getChildren() {
            return super.getChildren();
        }

        protected void layoutChildren() {
            double x = this.snappedLeftInset();
            double y = this.snappedTopInset();
            double width = this.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
            for (Node node : this.getChildren()) {
                double prefHeight = node.prefHeight(width);
                node.setLayoutX(x);
                if (node instanceof ExpansionPanel) {
                    ExpansionPanel expansionPanel = (ExpansionPanel)node;
                    ObservableList<ExpansionPanel> items = ((ExpansionPanelContainer)ExpansionPanelContainerSkin.this.getSkinnable()).getItems();
                    int itemIndex = items.indexOf((Object)expansionPanel);
                    if (items.indexOf((Object)expansionPanel) != 0 && !((ExpansionPanel)((Object)items.get(itemIndex - 1))).isExpanded()) {
                        if (this.animatedPanel == expansionPanel) {
                            y += this.animationFrac * 20.0;
                        } else if (expansionPanel.isExpanded()) {
                            y += 20.0;
                        }
                    }
                    expansionPanel.setLayoutY(y);
                    if (items.indexOf((Object)expansionPanel) != items.size() - 1) {
                        if (this.animatedPanel == expansionPanel) {
                            y += this.animationFrac * 20.0;
                        } else if (expansionPanel.isExpanded()) {
                            y += 20.0;
                        }
                    }
                } else {
                    node.setLayoutY(y);
                }
                node.resize(width, prefHeight);
                y += prefHeight;
            }
        }

        private class ExpandListener
        implements ChangeListener<Boolean> {
            private ExpansionPanel expansionPanel;

            public ExpandListener(ExpansionPanel expansionPanel) {
                this.expansionPanel = expansionPanel;
            }

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                Container.this.animatedPanel = this.expansionPanel;
                int index = Container.this.getChildren().indexOf((Object)this.expansionPanel);
                if (newValue.booleanValue()) {
                    if (index > 0 && Container.this.getChildren().get(index - 1) instanceof Separator) {
                        Container.this.getChildren().remove(index - 1);
                        --index;
                    }
                    if (index != Container.this.getChildren().size() - 1 && Container.this.getChildren().get(index + 1) instanceof Separator) {
                        Container.this.getChildren().remove(index + 1);
                    }
                    Container.this.expandAnimation = true;
                } else {
                    Node node;
                    if (index > 0 && (node = (Node)Container.this.getChildren().get(index - 1)) instanceof ExpansionPanel && !((ExpansionPanel)node).isExpanded()) {
                        Container.this.getChildren().add(index, (Object)ExpansionPanelContainerSkin.this.createSeparator());
                        ++index;
                    }
                    if (index != Container.this.getChildren().size() - 1 && (node = (Node)Container.this.getChildren().get(index + 1)) instanceof ExpansionPanel && !((ExpansionPanel)node).isExpanded()) {
                        Container.this.getChildren().add(index + 1, (Object)ExpansionPanelContainerSkin.this.createSeparator());
                    }
                    Container.this.expandAnimation = false;
                }
                Transition transition = new Transition(){
                    {
                        this.setCycleDuration(ANIMATION_DURATION);
                    }

                    protected void interpolate(double frac) {
                        Container.this.animationFrac = Container.this.expandAnimation ? frac : 1.0 - frac;
                        Container.this.requestLayout();
                    }
                };
                transition.setOnFinished(event -> {
                    Container.this.animationFrac = 1.0;
                    Container.this.animatedPanel = null;
                });
                transition.playFromStart();
            }
        }
    }
}

