/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.ExpansionPanel;
import com.gluonhq.charm.glisten.visual.MaterialDesignIcon;
import javafx.animation.Transition;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class ExpansionPanelSkin
extends SkinBase<ExpansionPanel> {
    private static final Duration animateUpDownDuration = Duration.millis((double)350.0);
    private final StackPane expandButtonContainer = new StackPane();
    private final Button expandButton = MaterialDesignIcon.KEYBOARD_ARROW_DOWN.button();
    private boolean animateDown;
    private boolean animateUp;
    private double animateFrac = 1.0;

    public ExpansionPanelSkin(ExpansionPanel control) {
        super((Control)control);
        this.expandButtonContainer.getChildren().add((Object)this.expandButton);
        this.getChildren().add((Object)this.expandButtonContainer);
        this.expandButton.getStyleClass().add((Object)"expand-button");
        this.expandButtonContainer.getStyleClass().add((Object)"expand-button-container");
        this.expandButton.setOnAction(event -> control.setExpanded(!control.isExpanded()));
        control.expandedProperty().addListener(listener -> this.updateExpandedState());
        if (control.isExpanded()) {
            this.expandButton.setText(MaterialDesignIcon.KEYBOARD_ARROW_UP.text);
            this.getChildren().add(0, (Object)control.getExpandedContent());
        } else {
            Node collapsedContent = control.getCollapsedContent();
            if (collapsedContent != null) {
                this.getChildren().add(0, (Object)collapsedContent);
            }
        }
    }

    private void updateExpandedState() {
        ExpansionPanel control = (ExpansionPanel)this.getSkinnable();
        Node collapsedContent = control.getCollapsedContent();
        Node expandedContent = control.getExpandedContent();
        if (collapsedContent == null || expandedContent == null) {
            return;
        }
        if (control.isExpanded()) {
            this.getChildren().remove((Object)control.getCollapsedContent());
            this.getChildren().add(0, (Object)control.getExpandedContent());
            this.animateDown = true;
        } else {
            this.animateUp = true;
        }
        this.expandButton.setText(control.isExpanded() ? MaterialDesignIcon.KEYBOARD_ARROW_UP.text : MaterialDesignIcon.KEYBOARD_ARROW_DOWN.text);
        Transition transition = new Transition(){
            {
                this.setCycleDuration(animateUpDownDuration);
            }

            protected void interpolate(double frac) {
                ExpansionPanelSkin.this.animateFrac = ExpansionPanelSkin.this.animateDown ? frac : 1.0 - frac;
                ((ExpansionPanel)ExpansionPanelSkin.this.getSkinnable()).requestLayout();
            }
        };
        transition.setOnFinished(event -> {
            if (this.animateUp) {
                this.getChildren().remove((Object)control.getExpandedContent());
                this.getChildren().add(0, (Object)control.getCollapsedContent());
            }
            this.animateDown = false;
            this.animateUp = false;
            this.animateFrac = 1.0;
            this.expandButton.setDisable(false);
        });
        this.animateFrac = 0.0;
        this.expandButton.setDisable(true);
        transition.playFromStart();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        ExpansionPanel control = (ExpansionPanel)this.getSkinnable();
        Node collapsedContent = control.getCollapsedContent();
        Node expandedContent = control.getExpandedContent();
        if (control.isExpanded() && expandedContent == null || !control.isExpanded() && collapsedContent == null) {
            this.expandButtonContainer.setVisible(false);
            return;
        }
        this.expandButtonContainer.setVisible(true);
        double width = contentWidth - this.snappedLeftInset() - this.snappedRightInset();
        double height = contentHeight - this.snappedTopInset() - this.snappedBottomInset();
        double collapsedPrefHeight = collapsedContent == null ? 0.0 : collapsedContent.prefHeight(width);
        double heightDisplacement = height - collapsedPrefHeight;
        double clipHeight = collapsedPrefHeight + heightDisplacement * this.animateFrac;
        Rectangle clip = new Rectangle(width, clipHeight);
        double expandButtonContainerPrefWidth = this.expandButtonContainer.prefWidth(-1.0);
        double expandButtonContainerPrefHeight = this.expandButtonContainer.prefHeight(expandButtonContainerPrefWidth);
        this.expandButtonContainer.resize(expandButtonContainerPrefWidth, expandButtonContainerPrefHeight);
        this.expandButtonContainer.setLayoutX(this.snappedLeftInset() + width - expandButtonContainerPrefWidth);
        this.expandButtonContainer.setLayoutY(this.snappedTopInset());
        Node content = (Node)this.getChildren().get(0);
        content.resize(width, clipHeight);
        content.setClip((Node)clip);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        ExpansionPanel control = (ExpansionPanel)this.getSkinnable();
        if (this.animateDown || this.animateUp) {
            double collapsedPrefHeight = control.getCollapsedContent().prefHeight(width);
            double heightDisplacement = control.getExpandedContent().prefHeight(width) - collapsedPrefHeight;
            double prefHeight = collapsedPrefHeight + heightDisplacement * this.animateFrac;
            return prefHeight;
        }
        if (control.isExpanded()) {
            Node expandedNode = control.getExpandedContent();
            if (expandedNode == null) {
                return 0.0;
            }
            return control.getExpandedContent().prefHeight(width);
        }
        Node collapsedNode = control.getCollapsedContent();
        if (collapsedNode == null) {
            return 0.0;
        }
        return control.getCollapsedContent().prefHeight(width);
    }
}

