/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class GlistenSwitchSkin
extends SkinBase<ToggleButton> {
    private final Region thumb = new Region();
    private final Region track = new Region();
    private double thumbWidth;
    private double thumbHeight;
    private double trackWidth;
    private double trackHeight;
    private ToggleButton control;
    private final TranslateTransition thumbTransition = new TranslateTransition(Duration.millis((double)1.0), (Node)this.thumb);

    public GlistenSwitchSkin(ToggleButton button) {
        super((Control)button);
        this.control = button;
        this.initialize();
    }

    private void initialize() {
        this.thumbTransition.setByX(1.0);
        this.thumbTransition.setCycleCount(1);
        this.thumbTransition.setAutoReverse(false);
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumb.setOnMouseReleased(e -> this.control.setSelected(!this.control.isSelected()));
        ((ToggleButton)this.getSkinnable()).selectedProperty().addListener(selected -> this.positionThumb(true));
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.track.setOnMouseReleased(e -> this.control.setSelected(e.getX() >= this.control.getPrefWidth() / 2.0));
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.track, this.thumb});
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.thumbWidth = this.snapSize(this.thumb.prefWidth(-1.0));
        this.thumbHeight = this.snapSize(this.thumb.prefHeight(-1.0));
        this.thumb.resizeRelocate(0.0, this.snapPosition(y + (h - this.thumbHeight) / 2.0), this.thumbWidth, this.thumbHeight);
        this.trackWidth = this.snapSize(this.track.prefWidth(-1.0));
        this.trackHeight = this.snapSize(this.track.prefHeight(-1.0));
        this.track.resizeRelocate(0.0, this.snapPosition(y + (h - this.trackHeight) / 2.0), this.trackWidth, this.trackHeight);
        this.positionThumb(false);
    }

    private void positionThumb(boolean animate) {
        this.thumbTransition.setDuration(Duration.millis((double)(animate ? 150.0 : 1.0)));
        this.thumbTransition.setToX(this.control.isSelected() ? this.snapPosition(this.trackWidth - this.thumbWidth) : 0.0);
        this.thumbTransition.play();
    }
}

