/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.attach.display.DisplayService;
import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.control.NavigationDrawer;
import com.gluonhq.charm.glisten.mvc.View;
import com.gluonhq.impl.charm.glisten.util.ViewTools;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class NavigationDrawerSkin
extends SkinBase<NavigationDrawer> {
    private final BorderPane content;
    private final ScrollPane scroller;
    private final VBox container;
    private static final int MOBILE_SUBTRAHEND = 56;
    private static final int MOBILE_MAX_WIDTH = 320;
    private static final int MOBILE_SUBTRAHEND_TABLET = 64;
    private static final int MOBILE_MAX_WIDTH_TABLET = 400;
    private EventHandler<MouseEvent> itemMouseEventHandler = event -> {
        Node item = (Node)event.getSource();
        ((NavigationDrawer)this.getSkinnable()).setSelectedItem(item);
        if (item instanceof NavigationDrawer.Item && ((NavigationDrawer.Item)item).isAutoClose()) {
            ((NavigationDrawer)this.getSkinnable()).close();
        }
        Event.fireEvent((EventTarget)this.getSkinnable(), (Event)new Event(NavigationDrawer.ITEM_SELECTED));
    };

    public NavigationDrawerSkin(NavigationDrawer navigationDrawer) {
        super((Control)navigationDrawer);
        this.container = new VBox();
        this.container.getStyleClass().add((Object)"container");
        this.scroller = new ScrollPane((Node)this.container);
        this.scroller.setFitToWidth(true);
        this.content = new BorderPane();
        this.content.setCenter((Node)this.scroller);
        double prefWidth = Math.min(navigationDrawer.getScene().getWidth() - 56.0, 320.0);
        this.content.setPrefWidth(DisplayService.create().filter(DisplayService::isTablet).map(s -> Math.min(navigationDrawer.getScene().getWidth() - 64.0, 400.0)).orElse(prefWidth).doubleValue());
        this.content.setMaxWidth(320.0);
        this.getChildren().add((Object)this.content);
        this.refreshNavigationDrawer();
        ((NavigationDrawer)this.getSkinnable()).headerProperty().addListener(observable -> this.refreshNavigationDrawer());
        ((NavigationDrawer)this.getSkinnable()).getItems().addListener(observable -> this.refreshNavigationDrawer());
        ((NavigationDrawer)this.getSkinnable()).footerProperty().addListener(observable -> this.refreshNavigationDrawer());
        for (Node item : ((NavigationDrawer)this.getSkinnable()).getItems()) {
            this.addHandlers(item);
        }
        ((NavigationDrawer)this.getSkinnable()).getItems().addListener(c -> {
            while (c.next()) {
                List items;
                if (c.wasAdded()) {
                    items = c.getAddedSubList();
                    for (Node item : items) {
                        this.addHandlers(item);
                    }
                    continue;
                }
                if (!c.wasRemoved()) continue;
                items = c.getRemoved();
                for (Node item : items) {
                    this.removeHandlers(item);
                }
            }
        });
        AppManager app = AppManager.getInstance();
        this.updateSelection(app.getView());
        app.viewProperty().addListener(o -> this.updateSelection(app.getView()));
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.content.resizeRelocate(x, y, w, h);
    }

    private void refreshNavigationDrawer() {
        Node header = ((NavigationDrawer)this.getSkinnable()).getHeader();
        ObservableList<Node> items = ((NavigationDrawer)this.getSkinnable()).getItems();
        Node footer = ((NavigationDrawer)this.getSkinnable()).getFooter();
        this.content.setTop(header);
        this.container.getChildren().clear();
        if (items != null) {
            this.container.getChildren().setAll(items);
        }
        if (footer != null) {
            this.container.getChildren().add((Object)footer);
        }
    }

    private void addHandlers(Node item) {
        item.addEventHandler(MouseEvent.MOUSE_CLICKED, this.itemMouseEventHandler);
    }

    private void removeHandlers(Node item) {
        item.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.itemMouseEventHandler);
    }

    private void updateSelection(View view) {
        for (Node item : ((NavigationDrawer)this.getSkinnable()).getItems()) {
            if (!(item instanceof NavigationDrawer.ViewItem) || !((NavigationDrawer.ViewItem)item).getViewName().equals(ViewTools.findViewName(view))) continue;
            ((NavigationDrawer)this.getSkinnable()).setSelectedItem(item);
            break;
        }
    }
}

