/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.ProgressBar;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class ProgressBarSkin
extends SkinBase<ProgressBar> {
    private StyleableObjectProperty<Paint> color = new SimpleStyleableObjectProperty(COLOR, (Object)this, "color", (Object)Paint.valueOf((String)"#3C87EE"));
    private static final double DARKER_BRIGHTER_FACTOR = 0.1;
    private static final double OPACITY_FACTOR = 0.25;
    private static final String DEFAULT_COLOR = "#3C87EE";
    private StackPane track;
    private StackPane bar;
    private StackPane helperBar;
    private double barWidth;
    private double helperBarWidth;
    private double barTranslateX;
    private double helperBarTranslateX;
    private Animation indeterminateTransition;
    private boolean wasIndeterminate = false;
    private static final CssMetaData<ProgressBar, Paint> COLOR = new CssMetaData<ProgressBar, Paint>("-fx-color", PaintConverter.getInstance(), Paint.valueOf((String)"#3C87EE")){

        public boolean isSettable(ProgressBar node) {
            ProgressBarSkin skin = (ProgressBarSkin)node.getSkin();
            return skin.color == null || !skin.color.isBound();
        }

        public StyleableProperty<Paint> getStyleableProperty(ProgressBar node) {
            ProgressBarSkin skin = (ProgressBarSkin)node.getSkin();
            return skin.color;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public ProgressBarSkin(ProgressBar control) {
        super((Control)control);
        Color lighterColor = null;
        Color currentColor = (Color)this.color.get();
        if (currentColor != null) {
            lighterColor = this.lighterTone(currentColor);
        }
        this.track = new StackPane();
        this.track.setPrefHeight(3.0);
        this.track.getStyleClass().setAll((Object[])new String[]{"pb-track"});
        this.track.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)lighterColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.bar = new StackPane();
        this.bar.setPrefHeight(3.0);
        this.bar.getStyleClass().setAll((Object[])new String[]{"pb-bar"});
        this.bar.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)currentColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.helperBar = new StackPane();
        this.helperBar.setPrefHeight(3.0);
        this.helperBar.getStyleClass().setAll((Object[])new String[]{"pb-bar"});
        this.helperBar.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)currentColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.track, this.bar, this.helperBar});
        this.color.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.track.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.lighterTone((Color)newValue), CornerRadii.EMPTY, Insets.EMPTY)}));
                this.bar.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(newValue, CornerRadii.EMPTY, Insets.EMPTY)}));
                this.helperBar.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(newValue, CornerRadii.EMPTY, Insets.EMPTY)}));
            }
        });
        InvalidationListener listener = valueModel -> this.updateProgress();
        control.widthProperty().addListener(listener);
        control.progressProperty().addListener(listener);
        control.requestLayout();
    }

    private Color lighterTone(Color currentColor) {
        return currentColor.deriveColor(0.0, 1.0, 10.0, 0.25);
    }

    private void updateProgress() {
        ProgressBar control = (ProgressBar)this.getSkinnable();
        boolean isIndeterminate = control.isIndeterminate();
        if (this.indeterminateTransition != null) {
            this.indeterminateTransition.stop();
            this.indeterminateTransition = null;
            this.barWidth = 0.0;
            this.barTranslateX = 0.0;
            this.helperBarWidth = 0.0;
            this.helperBarTranslateX = 0.0;
        }
        if (!isIndeterminate || !this.wasIndeterminate) {
            this.barWidth = (double)((int)(control.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, control.getProgress())) / 2.0;
        }
        this.wasIndeterminate = isIndeterminate;
        ((ProgressBar)this.getSkinnable()).requestLayout();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.track.resizeRelocate(x, y, w, h);
        this.bar.resizeRelocate(x + this.barTranslateX, y, this.barWidth, h);
        this.helperBar.resizeRelocate(x + this.helperBarTranslateX, y, this.helperBarWidth, h);
        boolean isIndeterminate = ((ProgressBar)this.getSkinnable()).isIndeterminate();
        if (isIndeterminate && this.indeterminateTransition == null) {
            this.createIndeterminateTimeline();
        }
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(100.0, leftInset + this.bar.prefWidth(((ProgressBar)this.getSkinnable()).getWidth()) + rightInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.bar.prefHeight(width) + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ProgressBar)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ProgressBar)this.getSkinnable()).prefHeight(width);
    }

    private void createIndeterminateTimeline() {
        this.indeterminateTransition = new IndeterminateTransition(this);
        this.indeterminateTransition.play();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ProgressBarSkin.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<ProgressBar, Paint>> styleables = new ArrayList<CssMetaData<ProgressBar, Paint>>(Control.getClassCssMetaData());
        styleables.add(COLOR);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static class IndeterminateTransition
    extends Transition {
        private final WeakReference<ProgressBarSkin> skin;
        double trackLength;

        IndeterminateTransition(ProgressBarSkin progressBarSkin) {
            this.skin = new WeakReference<ProgressBarSkin>(progressBarSkin);
            if (progressBarSkin != null) {
                this.trackLength = progressBarSkin.track.getWidth();
            }
            this.setInterpolator(Interpolator.LINEAR);
            this.setCycleCount(-1);
            this.setCycleDuration(Duration.seconds((double)2.0));
        }

        protected void interpolate(double frac) {
            ProgressBarSkin s = (ProgressBarSkin)((Object)this.skin.get());
            if (s == null) {
                this.stop();
            } else {
                if (!((ProgressBar)s.getSkinnable()).isIndeterminate()) {
                    s.barTranslateX = 0.0;
                    s.helperBarTranslateX = 0.0;
                } else if (frac <= 0.25) {
                    s.barWidth = 2.5 * frac * this.trackLength;
                } else if (frac > 0.25 && frac <= 0.375) {
                    s.barTranslateX = (3.0 * frac - 0.75) * this.trackLength;
                } else if (frac > 0.375 && frac <= 0.625) {
                    double delta = -2.5 * frac + 1.5625;
                    s.barWidth = delta * this.trackLength;
                    s.barTranslateX = this.trackLength - delta * this.trackLength;
                    if (frac > 0.5) {
                        s.helperBarWidth = (4.0 * frac - 2.0) * this.trackLength;
                    }
                } else if (frac > 0.625 && frac <= 0.75) {
                    if (frac < 0.65) {
                        s.helperBarWidth = (4.0 * frac - 2.0) * this.trackLength;
                    }
                    s.helperBarTranslateX = (2.64 * frac - 1.65) * this.trackLength;
                    s.barWidth = 0.0;
                    s.barTranslateX = 0.0;
                } else if (frac > 0.75 && frac <= 0.9) {
                    s.helperBarWidth = (-4.0 * frac + 3.6) * this.trackLength;
                    s.helperBarTranslateX = (4.466 * frac - 3.0194) * this.trackLength;
                } else if (frac > 0.9) {
                    s.barWidth = 0.0;
                    s.barTranslateX = 0.0;
                    s.helperBarWidth = 0.0;
                    s.helperBarTranslateX = 0.0;
                }
                ((ProgressBar)s.getSkinnable()).requestLayout();
            }
        }
    }
}

