/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.ProgressIndicator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.util.Duration;

public class ProgressIndicatorSkin
extends SkinBase<ProgressIndicator> {
    private StyleableObjectProperty<Paint> color = new SimpleStyleableObjectProperty(COLOR, (Object)this, "color", (Object)Paint.valueOf((String)"#3C87EE"));
    private static final double INDETERMINATE_TIME_INTERVAL = 1.4;
    private static final int INDETERMINATE_ANGLE_INTERVAL = 450;
    private static final String DEFAULT_COLOR = "#3C87EE";
    private final BooleanProperty isIndeterminate = new SimpleBooleanProperty(false);
    private boolean initialization;
    private boolean determinateInitialize;
    private Arc spinner;
    private Timeline timeline;
    private static final CssMetaData<ProgressIndicator, Paint> COLOR = new CssMetaData<ProgressIndicator, Paint>("-fx-color", PaintConverter.getInstance(), Paint.valueOf((String)"#3C87EE")){

        public boolean isSettable(ProgressIndicator node) {
            ProgressIndicatorSkin skin = (ProgressIndicatorSkin)node.getSkin();
            return skin.color == null || !skin.color.isBound();
        }

        public StyleableProperty<Paint> getStyleableProperty(ProgressIndicator node) {
            ProgressIndicatorSkin skin = (ProgressIndicatorSkin)node.getSkin();
            return skin.color;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public ProgressIndicatorSkin(ProgressIndicator control) {
        super((Control)control);
        this.isIndeterminate.bind((ObservableValue)((ProgressIndicator)this.getSkinnable()).indeterminateProperty());
        this.createNewSpinner(control);
        ((ProgressIndicator)this.getSkinnable()).indeterminateProperty().addListener((o, oldVal, newVal) -> {
            if (this.timeline != null) {
                this.timeline.stop();
            }
            this.initialization = false;
            ((ProgressIndicator)this.getSkinnable()).requestLayout();
        });
        ((ProgressIndicator)this.getSkinnable()).progressProperty().addListener((o, oldVal, newVal) -> {
            if (!this.isIndeterminate.get()) {
                this.updateProgress(newVal.doubleValue());
            }
        });
        this.initialize();
        control.requestLayout();
    }

    private void createNewSpinner(ProgressIndicator control) {
        double radius = control.getRadius();
        this.spinner = new Arc(0.0, 0.0, radius, radius, 90.0, 360.0);
        this.spinner.setStrokeWidth(3.0);
        this.spinner.setFill((Paint)Color.TRANSPARENT);
        this.spinner.getStyleClass().setAll((Object[])new String[]{"spinner"});
        this.spinner.strokeProperty().set((Object)((Paint)this.color.get()));
        control.radiusProperty().addListener(ov -> {
            this.spinner.setRadiusX(control.getRadius());
            this.spinner.setRadiusY(control.getRadius());
            control.requestLayout();
        });
        this.color.addListener((ov, oldValue, newValue) -> {
            if (newValue != null) {
                this.spinner.strokeProperty().set(newValue);
            }
        });
        this.getChildren().setAll((Object[])new Node[]{this.spinner});
    }

    private void initialize() {
        if (this.isIndeterminate.get()) {
            this.initializeTimeline();
        } else {
            this.updateProgress(((ProgressIndicator)this.getSkinnable()).getProgress());
        }
    }

    private void initializeTimeline() {
        int i;
        if (this.timeline == null) {
            this.timeline = new Timeline();
            this.timeline.setCycleCount(-1);
            this.timeline.setRate(1.0);
            this.timeline.setDelay(Duration.ZERO);
        } else {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
        }
        ObservableList keyFrames = FXCollections.observableArrayList();
        for (i = 0; i <= 3; ++i) {
            keyFrames.addAll(this.indeterminateKeyFrames(1.4 * (double)i, -(450 * i)));
        }
        keyFrames.add((Object)new KeyFrame(Duration.seconds((double)(1.4 * (double)i)), new KeyValue[]{new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)-5), new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)(-(450 * i) - 45))}));
        this.timeline.getKeyFrames().setAll((Collection)keyFrames);
        this.timeline.playFromStart();
    }

    private List<KeyFrame> indeterminateKeyFrames(double duration, int angle) {
        ObservableList keyFrames = FXCollections.observableArrayList();
        keyFrames.addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.seconds((double)duration), new KeyValue[]{new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)-5), new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)(angle -= 45))}), new KeyFrame(Duration.seconds((double)(duration + 0.4)), new KeyValue[]{new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)-250), new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)(angle -= 45))}), new KeyFrame(Duration.seconds((double)(duration + 0.7)), new KeyValue[]{new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)-250), new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)(angle -= 45))}), new KeyFrame(Duration.seconds((double)(duration + 1.1)), new KeyValue[]{new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)-5), new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)(angle - 300)), new KeyValue((WritableValue)this.spinner.strokeProperty(), (Object)((Paint)this.color.getValue()), Interpolator.EASE_BOTH)})});
        return keyFrames;
    }

    private void updateProgress(double progress) {
        if (!this.determinateInitialize) {
            if (this.timeline != null) {
                this.timeline.stop();
            }
            this.playDeterminateAnimation(progress);
            this.determinateInitialize = true;
        } else {
            this.spinner.setLength(-progress * 360.0);
            ((ProgressIndicator)this.getSkinnable()).requestLayout();
        }
    }

    private void playDeterminateAnimation(double progress) {
        Timeline timeline = new Timeline();
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)90), new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)0)}), new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)0), new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)(-progress * 0.25 * 360.0))}), new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)-90), new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)(-progress * 0.5 * 360.0))}), new KeyFrame(Duration.seconds((double)1.5), new KeyValue[]{new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)-180), new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)(-progress * 0.75 * 360.0))}), new KeyFrame(Duration.seconds((double)2.0), new KeyValue[]{new KeyValue((WritableValue)this.spinner.startAngleProperty(), (Object)-270, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.spinner.lengthProperty(), (Object)(-((int)(progress * 0.95 * 360.0))), Interpolator.EASE_BOTH)})});
        timeline.setCycleCount(1);
        timeline.play();
        timeline.setOnFinished(event -> {
            ((ProgressIndicator)this.getSkinnable()).requestLayout();
            this.updateProgress(progress);
        });
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.spinner.setCenterX(this.snapSize(x + ((ProgressIndicator)this.getSkinnable()).getRadius() + this.spinner.getStrokeWidth()));
        this.spinner.setCenterY(this.snapSize(y + ((ProgressIndicator)this.getSkinnable()).getRadius() + this.spinner.getStrokeWidth()));
        if (!this.initialization) {
            if (this.isIndeterminate.get()) {
                this.initializeTimeline();
            }
            if (!this.isIndeterminate.get()) {
                this.updateProgress(((ProgressIndicator)this.getSkinnable()).getProgress());
            }
            this.initialization = true;
        }
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + ((ProgressIndicator)this.getSkinnable()).getRadius() * 2.0 + this.spinner.getStrokeWidth() + 5.0 + rightInset;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + ((ProgressIndicator)this.getSkinnable()).getRadius() * 2.0 + this.spinner.getStrokeWidth() + 5.0 + bottomInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ProgressIndicatorSkin.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<ProgressIndicator, Paint>> styleables = new ArrayList<CssMetaData<ProgressIndicator, Paint>>(Control.getClassCssMetaData());
        styleables.add(COLOR);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

