/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.Rating;
import java.util.ArrayList;
import java.util.Collections;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

public class RatingSkin
extends SkinBase<Rating> {
    private static final String STRONG = "strong";
    private boolean updateOnHover;
    private boolean partialRating;
    private Pane backgroundContainer;
    private double rating = -1.0;
    private Rectangle foregroundClipRect;
    private final EventHandler<MouseEvent> mouseMoveHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (RatingSkin.this.updateOnHover) {
                RatingSkin.this.updateRatingFromMouseEvent(event);
            }
        }
    };
    private final EventHandler<MouseEvent> mouseClickHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (!RatingSkin.this.updateOnHover) {
                RatingSkin.this.updateRatingFromMouseEvent(event);
            }
        }
    };

    private void updateRatingFromMouseEvent(MouseEvent event) {
        Rating control = (Rating)this.getSkinnable();
        if (!control.ratingProperty().isBound()) {
            Point2D mouseLocation = new Point2D(event.getSceneX(), event.getSceneY());
            control.setRating(this.calculateRating(mouseLocation));
        }
    }

    private static double clamp(double min, double value, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public RatingSkin(Rating control) {
        super((Control)control);
        this.updateOnHover = control.isUpdateOnHover();
        this.partialRating = control.isPartialRating();
        this.recreateButtons();
        this.updateRating();
        this.registerChangeListener((ObservableValue)control.ratingProperty(), e -> this.updateRating());
        this.registerChangeListener((ObservableValue)control.maxProperty(), e -> this.recreateButtons());
        this.registerChangeListener((ObservableValue)control.orientationProperty(), e -> this.recreateButtons());
        this.registerChangeListener((ObservableValue)control.updateOnHoverProperty(), e -> {
            this.updateOnHover = ((Rating)this.getSkinnable()).isUpdateOnHover();
            this.recreateButtons();
        });
        this.registerChangeListener((ObservableValue)control.partialRatingProperty(), e -> {
            this.partialRating = ((Rating)this.getSkinnable()).isPartialRating();
            this.recreateButtons();
        });
        this.registerChangeListener((ObservableValue)control.boundsInLocalProperty(), e -> {
            if (this.partialRating) {
                this.updateClip();
            }
        });
    }

    private void recreateButtons() {
        this.backgroundContainer = null;
        VBox foregroundContainer = null;
        this.backgroundContainer = this.isVertical() ? new VBox() : new HBox();
        this.backgroundContainer.getStyleClass().add((Object)"container");
        this.getChildren().setAll((Object[])new Node[]{this.backgroundContainer});
        if (this.updateOnHover || this.partialRating) {
            foregroundContainer = this.isVertical() ? new VBox() : new HBox();
            foregroundContainer.getStyleClass().add((Object)"container");
            foregroundContainer.setMouseTransparent(true);
            this.getChildren().add((Object)foregroundContainer);
            this.foregroundClipRect = new Rectangle();
            foregroundContainer.setClip((Node)this.foregroundClipRect);
        }
        for (int index = 0; index <= ((Rating)this.getSkinnable()).getMax(); ++index) {
            Node backgroundNode = this.createButton();
            if (index <= 0) continue;
            if (this.isVertical()) {
                this.backgroundContainer.getChildren().add(0, (Object)backgroundNode);
            } else {
                this.backgroundContainer.getChildren().add((Object)backgroundNode);
            }
            if (!this.partialRating) continue;
            Node foregroundNode = this.createButton();
            foregroundNode.getStyleClass().add((Object)STRONG);
            foregroundNode.setMouseTransparent(true);
            if (this.isVertical()) {
                foregroundContainer.getChildren().add(0, (Object)foregroundNode);
                continue;
            }
            foregroundContainer.getChildren().add((Object)foregroundNode);
        }
        this.updateRating();
    }

    private double calculateRating(Point2D sceneLocation) {
        Point2D b = this.backgroundContainer.sceneToLocal(sceneLocation);
        double x = b.getX();
        double y = b.getY();
        Rating control = (Rating)this.getSkinnable();
        int max = control.getMax();
        double w = control.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double h = control.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double newRating = -1.0;
        newRating = this.isVertical() ? (h - y) / h * (double)max : x / w * (double)max;
        if (!this.partialRating) {
            newRating = RatingSkin.clamp(1.0, Math.ceil(newRating), control.getMax());
        }
        return newRating;
    }

    private void updateClip() {
        Rating control = (Rating)this.getSkinnable();
        double h = control.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double w = control.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        if (this.isVertical()) {
            double y = h * this.rating / (double)control.getMax();
            this.foregroundClipRect.relocate(0.0, h - y);
            this.foregroundClipRect.setWidth(control.getWidth());
            this.foregroundClipRect.setHeight(y);
        } else {
            double x = w * this.rating / (double)control.getMax();
            this.foregroundClipRect.setWidth(x);
            this.foregroundClipRect.setHeight(control.getHeight());
        }
    }

    private double getSpacing() {
        return this.backgroundContainer instanceof HBox ? ((HBox)this.backgroundContainer).getSpacing() : ((VBox)this.backgroundContainer).getSpacing();
    }

    private Node createButton() {
        Region btn = new Region();
        btn.getStyleClass().add((Object)"button");
        btn.setOnMouseMoved(this.mouseMoveHandler);
        btn.setOnMouseClicked(this.mouseClickHandler);
        return btn;
    }

    private void updateRating() {
        double newRating = ((Rating)this.getSkinnable()).getRating();
        if (newRating == this.rating) {
            return;
        }
        this.rating = RatingSkin.clamp(0.0, newRating, ((Rating)this.getSkinnable()).getMax());
        if (this.partialRating) {
            this.updateClip();
        } else {
            this.updateButtonStyles();
        }
    }

    private void updateButtonStyles() {
        int max = ((Rating)this.getSkinnable()).getMax();
        ArrayList buttons = new ArrayList(this.backgroundContainer.getChildren());
        if (this.isVertical()) {
            Collections.reverse(buttons);
        }
        for (int i = 0; i < max; ++i) {
            Node button = (Node)buttons.get(i);
            ObservableList styleClass = button.getStyleClass();
            boolean containsStrong = styleClass.contains(STRONG);
            if ((double)i < this.rating) {
                if (containsStrong) continue;
                styleClass.add(STRONG);
                continue;
            }
            if (!containsStrong) continue;
            styleClass.remove(STRONG);
        }
    }

    private boolean isVertical() {
        return ((Rating)this.getSkinnable()).getOrientation() == Orientation.VERTICAL;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }
}

