/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.TextField;
import com.gluonhq.charm.glisten.control.skin.TextInputSkin;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
import javafx.scene.control.TextInputControl;

public class TextFieldSkin
extends TextInputSkin {
    private Label counterLabel;
    private ChangeListener<Number> lengthChangeListener;

    public TextFieldSkin(TextField control) {
        super(control, (TextInputControl)new javafx.scene.control.TextField(), 0.0);
        control.maxLengthProperty().addListener(ov -> this.updateChildren());
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double textFieldStartY = this.floatLabel == null ? this.snapPosition(y) : this.snapPosition(y) + 10.0;
        double textFieldHeight = this.innerTextControl.prefHeight(w);
        this.innerTextControl.resizeRelocate(x, textFieldStartY, w, textFieldHeight);
        if (this.counterLabel != null) {
            double counterLabelWidth = this.counterLabel.prefWidth(-1.0);
            double counterStartX = x + w - counterLabelWidth;
            double counterStartY = textFieldStartY + textFieldHeight + 5.0;
            this.counterLabel.resizeRelocate(counterStartX, counterStartY, counterLabelWidth, this.counterLabel.prefHeight(-1.0));
        }
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefHeight = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        double counterLabelHeight = this.counterLabel == null || this.errorLabel != null ? 0.0 : this.counterLabel.prefHeight(-1.0) + 5.0;
        return prefHeight + counterLabelHeight;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    void updateChildren() {
        super.updateChildren();
        if (((TextField)this.control).getMaxLength() > 0) {
            this.createAndAddCounterLabel();
        }
    }

    @Override
    void bindInnerControlProperties() {
        super.bindInnerControlProperties();
        this.innerTextControl.lengthProperty().addListener(this.lengthChangeListener);
    }

    @Override
    void unbindInnerControlProperties() {
        super.unbindInnerControlProperties();
        if (this.lengthChangeListener == null) {
            this.lengthChangeListener = (ov, oldValue, newValue) -> this.control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, ((TextField)this.control).getMaxLength() > 0 && newValue.intValue() > ((TextField)this.control).getMaxLength());
        }
        this.innerTextControl.lengthProperty().removeListener(this.lengthChangeListener);
    }

    private void createAndAddCounterLabel() {
        this.unbindCounterProperties();
        this.counterLabel = new Label();
        this.counterLabel.setFocusTraversable(false);
        this.counterLabel.getStyleClass().setAll((Object[])new String[]{"counter"});
        this.counterLabel.textProperty().bind((ObservableValue)this.innerTextControl.lengthProperty().asString().concat((Object)"/").concat((Object)((TextField)this.control).maxLengthProperty()));
        this.getChildren().add((Object)this.counterLabel);
    }

    private void unbindCounterProperties() {
        if (this.counterLabel != null && this.counterLabel.textProperty().isBound()) {
            this.counterLabel.textProperty().unbind();
        }
    }
}

