/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.ToggleButtonGroup;
import java.util.Collection;
import java.util.HashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;

public class ToggleButtonGroupSkin
extends SkinBase<ToggleButtonGroup> {
    private static final String NO_SELECTION_STYLE = "no-selection";
    private static final String LEFT_STYLE = "left";
    private static final String RIGHT_STYLE = "right";
    private static final String CENTER_STYLE = "center";
    private HashMap<ToggleButton, SelectedListener> toggleButtonToListener = new HashMap();
    private ToggleButton firstToggle;
    private ToggleButton lastToggle;

    public ToggleButtonGroupSkin(ToggleButtonGroup control) {
        super((Control)control);
        control.getToggles().addListener(c -> {
            this.updateButtonStyle((ListChangeListener.Change<? extends ToggleButton>)c);
            this.updateChildren((ListChangeListener.Change<? extends ToggleButton>)c);
        });
        for (ToggleButton toggleButton : control.getToggles()) {
            this.getChildren().add((Object)toggleButton);
            SelectedListener selectedListener = new SelectedListener(toggleButton);
            this.toggleButtonToListener.put(toggleButton, selectedListener);
            toggleButton.selectedProperty().addListener((InvalidationListener)selectedListener);
        }
        this.initButtonStyle();
    }

    private void updateChildren(ListChangeListener.Change<? extends ToggleButton> changed) {
        while (changed.next()) {
            SelectedListener selectedListener;
            if (changed.wasAdded()) {
                this.getChildren().addAll((Collection)changed.getAddedSubList());
                for (ToggleButton toggleButton : changed.getAddedSubList()) {
                    selectedListener = new SelectedListener(toggleButton);
                    this.toggleButtonToListener.put(toggleButton, selectedListener);
                    toggleButton.selectedProperty().addListener((InvalidationListener)selectedListener);
                }
            }
            if (!changed.wasRemoved()) continue;
            this.getChildren().removeAll((Collection)changed.getRemoved());
            for (ToggleButton toggleButton : changed.getRemoved()) {
                selectedListener = this.toggleButtonToListener.get(toggleButton);
                toggleButton.selectedProperty().removeListener((InvalidationListener)selectedListener);
                this.toggleButtonToListener.remove(toggleButton);
            }
        }
    }

    private void initButtonStyle() {
        boolean isOneSelected = false;
        ToggleButtonGroup tBGroup = (ToggleButtonGroup)this.getSkinnable();
        for (int i = 0; i < tBGroup.getToggles().size(); ++i) {
            ToggleButton toggleButton = (ToggleButton)tBGroup.getToggles().get(i);
            if (toggleButton.isSelected()) {
                isOneSelected = true;
            }
            if (i == 0) {
                toggleButton.getStyleClass().add((Object)LEFT_STYLE);
                this.firstToggle = toggleButton;
                continue;
            }
            if (i == tBGroup.getToggles().size() - 1) {
                toggleButton.getStyleClass().add((Object)RIGHT_STYLE);
                this.lastToggle = toggleButton;
                continue;
            }
            toggleButton.getStyleClass().add((Object)CENTER_STYLE);
        }
        if (!isOneSelected) {
            tBGroup.getStyleClass().add((Object)NO_SELECTION_STYLE);
        }
    }

    private void updateButtonStyle(ListChangeListener.Change<? extends ToggleButton> changed) {
        ToggleButtonGroup tBGroup = (ToggleButtonGroup)this.getSkinnable();
        while (changed.next()) {
            if (!changed.wasAdded()) continue;
            for (ToggleButton toggleButton : changed.getAddedSubList()) {
                if (toggleButton == tBGroup.getToggles().get(0) || toggleButton == tBGroup.getToggles().get(tBGroup.getToggles().size() - 1)) continue;
                toggleButton.getStyleClass().add((Object)CENTER_STYLE);
            }
        }
        if (this.firstToggle != tBGroup.getToggles().get(0)) {
            this.firstToggle.getStyleClass().remove((Object)LEFT_STYLE);
            if (tBGroup.getToggles().contains((Object)this.firstToggle)) {
                if (this.firstToggle != tBGroup.getToggles().get(tBGroup.getToggles().size() - 1)) {
                    this.firstToggle.getStyleClass().add((Object)CENTER_STYLE);
                } else {
                    this.firstToggle.getStyleClass().add((Object)RIGHT_STYLE);
                }
            }
            this.firstToggle = (ToggleButton)tBGroup.getToggles().get(0);
            this.firstToggle.getStyleClass().removeAll((Object[])new String[]{CENTER_STYLE, RIGHT_STYLE});
            this.firstToggle.getStyleClass().add((Object)LEFT_STYLE);
        }
        if (this.lastToggle != tBGroup.getToggles().get(tBGroup.getToggles().size() - 1)) {
            this.lastToggle.getStyleClass().remove((Object)RIGHT_STYLE);
            if (tBGroup.getToggles().contains((Object)this.lastToggle)) {
                if (this.lastToggle != tBGroup.getToggles().get(0)) {
                    this.lastToggle.getStyleClass().add((Object)CENTER_STYLE);
                } else {
                    this.lastToggle.getStyleClass().add((Object)LEFT_STYLE);
                }
            }
            this.lastToggle = (ToggleButton)tBGroup.getToggles().get(tBGroup.getToggles().size() - 1);
            this.lastToggle.getStyleClass().removeAll((Object[])new String[]{CENTER_STYLE, LEFT_STYLE});
            this.lastToggle.getStyleClass().add((Object)RIGHT_STYLE);
        }
    }

    private void updateNoSelectionStyle(ToggleButton toggleButton) {
        ToggleButtonGroup tBGroup = (ToggleButtonGroup)this.getSkinnable();
        if (toggleButton.isSelected() && tBGroup.getStyleClass().contains((Object)NO_SELECTION_STYLE)) {
            tBGroup.getStyleClass().remove((Object)NO_SELECTION_STYLE);
        } else {
            boolean isOneSelected = false;
            for (ToggleButton tb : tBGroup.getToggles()) {
                if (!tb.isSelected()) continue;
                isOneSelected = true;
            }
            if (!isOneSelected) {
                tBGroup.getStyleClass().add((Object)NO_SELECTION_STYLE);
            }
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double width = leftInset + rightInset;
        for (ToggleButton toggleButton : ((ToggleButtonGroup)this.getSkinnable()).getToggles()) {
            width += toggleButton.prefWidth(-1.0);
        }
        return width;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        ObservableList<ToggleButton> toggles = ((ToggleButtonGroup)this.getSkinnable()).getToggles();
        if (toggles.size() == 0) {
            return 0.0;
        }
        return topInset + bottomInset + ((ToggleButton)toggles.get(0)).prefHeight(-1.0);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double currPosX = contentX;
        ObservableList<ToggleButton> toggles = ((ToggleButtonGroup)this.getSkinnable()).getToggles();
        if (toggles.size() == 0) {
            return;
        }
        double prefHeight = ((ToggleButton)toggles.get(0)).prefHeight(-1.0);
        for (ToggleButton toggleButton : ((ToggleButtonGroup)this.getSkinnable()).getToggles()) {
            toggleButton.setLayoutX(currPosX);
            toggleButton.setLayoutY(contentY);
            toggleButton.resize(toggleButton.prefWidth(-1.0), prefHeight);
            currPosX += toggleButton.prefWidth(-1.0);
        }
    }

    private class SelectedListener
    implements InvalidationListener {
        private ToggleButton toggleButton;

        public SelectedListener(ToggleButton toggleButton) {
            this.toggleButton = toggleButton;
        }

        public void invalidated(Observable observable) {
            ToggleButtonGroupSkin.this.updateNoSelectionStyle(this.toggleButton);
        }
    }
}

