/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin.navigationdrawer;

import com.gluonhq.charm.glisten.control.NavigationDrawer;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class HeaderSkin
extends SkinBase<NavigationDrawer.Header> {
    private final VBox content = new VBox();

    public HeaderSkin(NavigationDrawer.Header control) {
        super((Control)control);
        this.content.getStyleClass().add((Object)"header-content");
        this.getChildren().add((Object)this.content);
        this.refreshHeader();
        ((NavigationDrawer.Header)this.getSkinnable()).titleProperty().addListener(observable -> this.refreshHeader());
        ((NavigationDrawer.Header)this.getSkinnable()).subtitleProperty().addListener(observable -> this.refreshHeader());
        ((NavigationDrawer.Header)this.getSkinnable()).graphicProperty().addListener(observable -> this.refreshHeader());
        ((NavigationDrawer.Header)this.getSkinnable()).onActionProperty().addListener(observable -> this.refreshHeader());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.content.resizeRelocate(x, y, w, h);
    }

    private HBox createImageBox() {
        HBox imageBox = new HBox();
        imageBox.getChildren().addAll((Object[])new Node[]{((NavigationDrawer.Header)this.getSkinnable()).getGraphic()});
        return imageBox;
    }

    private HBox createTextBox() {
        HBox textBox = new HBox();
        textBox.setAlignment(Pos.CENTER_LEFT);
        textBox.getStyleClass().add((Object)"text-box");
        VBox textContainer = new VBox();
        String title = ((NavigationDrawer.Header)this.getSkinnable()).getTitle();
        String subtitle = ((NavigationDrawer.Header)this.getSkinnable()).getSubtitle();
        if (title != null) {
            Label titleLabel = new Label(title);
            titleLabel.getStyleClass().setAll((Object[])new String[]{"title"});
            textContainer.getChildren().add((Object)titleLabel);
        }
        if (subtitle != null) {
            Label subtitleLabel = new Label(subtitle);
            subtitleLabel.getStyleClass().setAll((Object[])new String[]{"subtitle"});
            textContainer.getChildren().add((Object)subtitleLabel);
        }
        Region gap = new Region();
        HBox.setHgrow((Node)gap, (Priority)Priority.ALWAYS);
        textBox.getChildren().addAll((Object[])new Node[]{textContainer, gap});
        EventHandler<ActionEvent> onAction = ((NavigationDrawer.Header)this.getSkinnable()).getOnAction();
        if (onAction != null) {
            StackPane arrow = new StackPane();
            arrow.setId("arrow");
            arrow.getStyleClass().setAll((Object[])new String[]{"arrow"});
            StackPane arrowRegion = new StackPane();
            arrowRegion.getStyleClass().add((Object)"arrow-region");
            arrowRegion.getChildren().setAll((Object[])new Node[]{new Group(new Node[]{arrow})});
            arrowRegion.setOnMouseClicked(event -> onAction.handle((Event)new ActionEvent()));
            textBox.getChildren().add((Object)arrowRegion);
        }
        return textBox;
    }

    private void refreshHeader() {
        this.content.getChildren().clear();
        if (((NavigationDrawer.Header)this.getSkinnable()).getGraphic() != null) {
            this.content.getChildren().setAll((Object[])new Node[]{this.createImageBox()});
        }
        this.content.getChildren().add((Object)this.createTextBox());
    }
}

