/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin.navigationdrawer;

import com.gluonhq.charm.glisten.control.NavigationDrawer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class ItemSkin
extends SkinBase<NavigationDrawer.Item> {
    private HBox content = new HBox();

    public ItemSkin(NavigationDrawer.Item control) {
        super((Control)control);
        this.content.getStyleClass().add((Object)"item-content");
        this.getChildren().setAll((Object[])new Node[]{this.content});
        this.refreshItem();
        ((NavigationDrawer.Item)this.getSkinnable()).titleProperty().addListener(observable -> this.refreshItem());
        ((NavigationDrawer.Item)this.getSkinnable()).graphicProperty().addListener(observable -> this.refreshItem());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.content.resizeRelocate(x, y, w, h);
    }

    private HBox createTextBox() {
        String title = ((NavigationDrawer.Item)this.getSkinnable()).getTitle();
        Label labelTitle = new Label(title != null ? title : "");
        HBox.setHgrow((Node)labelTitle, (Priority)Priority.ALWAYS);
        HBox textBox = new HBox(new Node[]{labelTitle});
        textBox.getStyleClass().setAll((Object[])new String[]{"text-box"});
        textBox.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)textBox);
        return textBox;
    }

    private HBox createImageBox() {
        HBox imageBox = new HBox();
        Node graphic = ((NavigationDrawer.Item)this.getSkinnable()).getGraphic();
        if (graphic != null) {
            imageBox = new HBox();
            imageBox.getStyleClass().setAll((Object[])new String[]{"image-box"});
            imageBox.setAlignment(Pos.CENTER_LEFT);
            imageBox.getChildren().add((Object)graphic);
            this.getChildren().add((Object)imageBox);
        }
        return imageBox;
    }

    private void refreshItem() {
        this.content.getChildren().clear();
        this.content.getChildren().add((Object)this.createImageBox());
        this.content.getChildren().add((Object)this.createTextBox());
    }
}

