/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control.skin.settings;

import com.gluonhq.charm.glisten.animation.FadeInDownBigTransition;
import com.gluonhq.charm.glisten.animation.MobileTransition;
import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.control.AppBar;
import com.gluonhq.charm.glisten.control.SettingsPane;
import com.gluonhq.charm.glisten.control.settings.Option;
import com.gluonhq.charm.glisten.control.settings.OptionBase;
import com.gluonhq.charm.glisten.control.settings.OptionEditor;
import com.gluonhq.charm.glisten.control.settings.OptionEditorBase;
import com.gluonhq.charm.glisten.mvc.View;
import com.gluonhq.charm.glisten.visual.MaterialDesignIcon;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.StringConverter;

public class SettingsSkin
extends SkinBase<SettingsPane> {
    private final BorderPane content;
    private final ScrollPane scroller;
    private final ToolBar toolbar;
    private int level = 0;
    private static final Function<View, MobileTransition> VIEW_TRANSITION = view -> new FadeInDownBigTransition((Node)view, false);

    public SettingsSkin(SettingsPane control) {
        super((Control)control);
        TextField textField = new TextField();
        HBox.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
        HBox searchField = new HBox(new Node[]{textField, MaterialDesignIcon.SEARCH.button((EventHandler<ActionEvent>)((EventHandler)e -> ((SettingsPane)this.getSkinnable()).setTitleFilter(textField.getText())))});
        HBox.setHgrow((Node)searchField, (Priority)Priority.ALWAYS);
        this.toolbar = new ToolBar();
        this.toolbar.getItems().addAll((Object[])new Node[]{searchField});
        searchField.managedProperty().bind((ObservableValue)searchField.visibleProperty());
        searchField.setVisible(((SettingsPane)this.getSkinnable()).isSearchBoxVisible());
        ((SettingsPane)this.getSkinnable()).searchBoxVisibleProperty().addListener(o -> searchField.setVisible(((SettingsPane)this.getSkinnable()).isSearchBoxVisible()));
        this.toolbar.visibleProperty().bind((ObservableValue)searchField.visibleProperty());
        this.toolbar.managedProperty().bind((ObservableValue)searchField.visibleProperty());
        this.scroller = new ScrollPane();
        this.scroller.setFitToWidth(true);
        this.content = new BorderPane();
        this.content.setTop((Node)this.toolbar);
        this.content.setCenter((Node)this.scroller);
        this.getChildren().add((Object)this.content);
        this.refreshSettings();
        ((SettingsPane)this.getSkinnable()).optionEditorFactory().addListener(o -> this.refreshSettings());
        ((SettingsPane)this.getSkinnable()).titleFilter().addListener(o -> this.refreshSettings());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.content.resizeRelocate(x, y, w, h);
    }

    private void refreshSettings() {
        this.scroller.setContent((Node)this.buildSettingsContainer(((SettingsPane)this.getSkinnable()).getOptions()));
    }

    private VBox buildSettingsContainer(ObservableList<Option> options) {
        String search = ((SettingsPane)this.getSkinnable()).getTitleFilter().toLowerCase(Locale.ROOT);
        FilteredList filteredOptions = new FilteredList(options);
        filteredOptions.setPredicate(option -> search.isEmpty() || option.getCaption() != null && option.getCaption().toLowerCase(Locale.ROOT).contains(search) || option.getDescription() != null && option.getDescription().toLowerCase(Locale.ROOT).contains(search));
        boolean graphic = false;
        TreeMap<String, ArrayList<OptionBase>> categoryMap = new TreeMap<String, ArrayList<OptionBase>>();
        for (Option o : filteredOptions) {
            ArrayList<OptionBase> list;
            if (!(o instanceof OptionBase)) continue;
            String category = ((OptionBase)o).getCategory();
            if (category == null) {
                category = "";
            }
            if ((list = (ArrayList<OptionBase>)categoryMap.get(category)) == null) {
                list = new ArrayList<OptionBase>();
                categoryMap.put(category, list);
            }
            list.add((OptionBase)o);
            if (graphic || !((OptionBase)o).getGraphic().isPresent()) continue;
            graphic = true;
        }
        VBox grid = new VBox();
        grid.getStyleClass().add((Object)"options-grid");
        for (Option option2 : filteredOptions) {
            Label labelTitle;
            String category = option2.getCategory() == null ? "" : option2.getCategory();
            List list = (List)categoryMap.get(category);
            if (list.size() > 0 && ((OptionBase)list.get(0)).equals(option2) && !category.isEmpty()) {
                HBox cat = new HBox(new Node[]{new Label(category)});
                cat.getStyleClass().add((Object)"subheader");
                cat.setAlignment(Pos.CENTER_LEFT);
                grid.getChildren().add((Object)cat);
            }
            if (option2.getCaption().equals("Separator")) {
                HBox hBox = new HBox();
                hBox.getStyleClass().add((Object)"separator");
                grid.getChildren().add((Object)hBox);
                continue;
            }
            boolean hLayout = true;
            Node editor = this.getEditor(option2);
            if (editor != null) {
                if (editor instanceof Slider || Orientation.VERTICAL.equals((Object)option2.getLayout())) {
                    hLayout = false;
                    editor.getStyleClass().add((Object)"editor-large");
                } else {
                    editor.getStyleClass().add((Object)"editor");
                }
            }
            HBox rowOption = new HBox();
            rowOption.getStyleClass().add((Object)"option-row");
            if (option2.getGraphic().isPresent()) {
                HBox grLeft = new HBox();
                grLeft.setAlignment(Pos.CENTER_LEFT);
                grLeft.getStyleClass().add((Object)"primary-graphic");
                grLeft.getChildren().add((Object)option2.getGraphic().get());
                rowOption.getChildren().add((Object)grLeft);
                HBox.setHgrow((Node)grLeft, (Priority)Priority.NEVER);
            }
            if (hLayout) {
                String viewName;
                labelTitle = new Label(option2.getCaption());
                labelTitle.getStyleClass().add((Object)"primary-text");
                Label labelSubtitle = new Label();
                labelSubtitle.getStyleClass().add((Object)"secondary-text");
                labelSubtitle.setAlignment(Pos.TOP_LEFT);
                VBox.setVgrow((Node)labelTitle, (Priority)Priority.ALWAYS);
                VBox textBox = new VBox(new Node[]{labelTitle, labelSubtitle});
                textBox.getStyleClass().setAll((Object[])new String[]{"text-box"});
                textBox.setAlignment(Pos.CENTER_LEFT);
                HBox.setHgrow((Node)textBox, (Priority)Priority.ALWAYS);
                rowOption.getChildren().add((Object)textBox);
                if (!option2.getExtendedDescription().isPresent()) {
                    labelSubtitle.setText(option2.getDescription());
                    Tooltip.install((Node)textBox, (Tooltip)new Tooltip(option2.getDescription()));
                } else {
                    labelSubtitle.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                        if (option2.getStringConverter().isPresent()) {
                            StringConverter converter = option2.getStringConverter().get();
                            return converter.toString(option2.valueProperty().getValue());
                        }
                        return option2.valueProperty().getValue().toString();
                    }, (Observable[])new Observable[]{option2.valueProperty()}));
                    Tooltip.install((Node)textBox, (Tooltip)new Tooltip("Click to find a more extensive description about " + option2.getCaption()));
                }
                if (editor != null) {
                    if (!option2.getExtendedDescription().isPresent()) {
                        HBox grRight = new HBox(new Node[]{editor});
                        grRight.setAlignment(Pos.CENTER);
                        HBox.setHgrow((Node)grRight, (Priority)Priority.NEVER);
                        grRight.getStyleClass().add((Object)"secondary-graphic");
                        rowOption.getChildren().add((Object)grRight);
                    } else {
                        viewName = "Extended_View_" + option2.getCaption() + "_" + this.level + "_" + rowOption.getChildren().size();
                        AppManager.getInstance().addViewFactory(viewName, () -> {
                            View view = this.getExtendedView(option2);
                            view.setShowTransitionFactory(VIEW_TRANSITION);
                            return view;
                        });
                        rowOption.setOnMouseClicked(e -> AppManager.getInstance().switchView(viewName));
                    }
                } else if (!option2.getChildren().isEmpty()) {
                    viewName = "Group_View_" + option2.getCaption() + "_" + this.level + "_" + rowOption.getChildren().size();
                    AppManager.getInstance().addViewFactory(viewName, () -> {
                        View view = this.getGroupView(option2.getCaption(), this.buildSettingsContainer(option2.getChildren()));
                        view.setShowTransitionFactory(VIEW_TRANSITION);
                        return view;
                    });
                    rowOption.setOnMouseClicked(e -> AppManager.getInstance().switchView(viewName));
                } else {
                    System.out.println("Error, no rendering options for: " + option2.getCaption());
                }
            } else {
                labelTitle = new Label(option2.getCaption());
                labelTitle.getStyleClass().add((Object)"primary-text");
                VBox grRight = new VBox(new Node[]{labelTitle, editor});
                grRight.setAlignment(Pos.CENTER_LEFT);
                HBox.setHgrow((Node)grRight, (Priority)Priority.ALWAYS);
                grRight.getStyleClass().addAll((Object[])new String[]{"text-box", "secondary-graphic"});
                rowOption.getChildren().add((Object)grRight);
            }
            grid.getChildren().add((Object)rowOption);
        }
        ++this.level;
        return grid;
    }

    private Node getEditor(Option option) {
        if (option.valueProperty() == null || option.valueProperty().getValue() == null) {
            return null;
        }
        OptionEditor editor = (OptionEditor)((SettingsPane)this.getSkinnable()).getOptionEditorFactory().call((Object)option);
        if (editor == null) {
            editor = new OptionEditorBase<String, TextField>(option, new TextField(), true){
                {
                    ((TextField)this.getEditor()).setEditable(false);
                    ((TextField)this.getEditor()).setDisable(true);
                }

                public StringProperty valueProperty() {
                    return ((TextField)this.getEditor()).textProperty();
                }

                @Override
                public void setValue(String value) {
                    ((TextField)this.getEditor()).setText(value == null ? "" : value);
                }
            };
        } else if (!option.isEditable()) {
            editor.getEditor().setDisable(true);
        }
        try {
            editor.setValue(option.valueProperty().getValue());
        }
        catch (ClassCastException e) {
            editor.setValue(option.valueProperty().getValue().toString());
        }
        return editor.getEditor();
    }

    private View getGroupView(final String caption, VBox vBox) {
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)"settings-pane");
        final Button btnBack = MaterialDesignIcon.ARROW_BACK.button((EventHandler<ActionEvent>)((EventHandler)e -> AppManager.getInstance().switchToPreviousView()));
        final Button btnSearch = MaterialDesignIcon.SEARCH.button();
        pane.setCenter((Node)vBox);
        View view = new View((Node)pane){

            @Override
            protected void updateAppBar(AppBar appBar) {
                appBar.setNavIcon((Node)btnBack);
                appBar.setTitleText(caption);
                appBar.getActionItems().add((Object)btnSearch);
            }
        };
        return view;
    }

    private View getExtendedView(final Option option) {
        BorderPane pane = new BorderPane();
        pane.getStyleClass().add((Object)"settings-pane");
        final Button btnBack = MaterialDesignIcon.ARROW_BACK.button((EventHandler<ActionEvent>)((EventHandler)e -> AppManager.getInstance().switchToPreviousView()));
        final Button btnSearch = MaterialDesignIcon.SEARCH.button();
        HBox top = new HBox();
        top.setAlignment(Pos.CENTER);
        top.getStyleClass().add((Object)"extended-top");
        Node editor = this.getEditor(option);
        editor.getStyleClass().add((Object)"editor");
        Label label = new Label();
        label.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (option.getStringConverter().isPresent()) {
                StringConverter converter = option.getStringConverter().get();
                return converter.toString(option.valueProperty().getValue());
            }
            return option.valueProperty().getValue().toString();
        }, (Observable[])new Observable[]{option.valueProperty()}));
        Region spacer2 = new Region();
        HBox.setHgrow((Node)spacer2, (Priority)Priority.ALWAYS);
        top.getChildren().addAll((Object[])new Node[]{label, spacer2, editor});
        BorderPane paneContent = new BorderPane();
        paneContent.getStyleClass().add((Object)"extended-pane");
        paneContent.setTop((Node)top);
        Text text = new Text();
        if (option.getExtendedDescription().isPresent()) {
            text.setText(option.getExtendedDescription().get());
        }
        text.getStyleClass().add((Object)"extended-text");
        TextFlow textFlow = new TextFlow(new Node[]{text}){

            protected void layoutChildren() {
                super.layoutChildren();
                double maxChildHeight = 0.0;
                for (Node child : this.getManagedChildren()) {
                    maxChildHeight = Math.max(maxChildHeight, child.getLayoutBounds().getHeight());
                }
                this.setMaxHeight(maxChildHeight + this.getInsets().getTop() + this.getInsets().getBottom());
            }
        };
        HBox hBox = new HBox(new Node[]{textFlow});
        hBox.setAlignment(Pos.CENTER);
        hBox.getStyleClass().add((Object)"extended-center");
        paneContent.setCenter((Node)hBox);
        pane.setCenter((Node)paneContent);
        View view = new View((Node)pane){

            @Override
            protected void updateAppBar(AppBar appBar) {
                appBar.setNavIcon((Node)btnBack);
                appBar.setTitleText(option.getCaption());
                appBar.getActionItems().add((Object)btnSearch);
            }
        };
        return view;
    }
}

