/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.layout;

import com.gluonhq.charm.glisten.animation.NoTransition;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import com.gluonhq.impl.charm.glisten.application.GlassPaneHelper;
import java.util.Optional;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.layout.Pane;

public class Layer
extends Pane {
    private boolean requiresShowAnimation;
    private boolean requiresHideAnimation;
    private Transition showTransition;
    private Transition hideTransition;
    private Layer parentLayer;
    private final BooleanProperty showingProperty = new SimpleBooleanProperty((Object)this, "showing", false){

        protected void invalidated() {
            Layer.this.setVisible(this.get());
        }
    };
    private final BooleanProperty autoHide = new SimpleBooleanProperty((Object)this, "autoHide", true);
    private final ObjectProperty<Function<Layer, Transition>> showTransitionFactory = new SimpleObjectProperty((Object)this, "showTransitionFactory");
    private final ObjectProperty<Function<Layer, Transition>> hideTransitionFactory = new SimpleObjectProperty((Object)this, "showTransitionFactory");
    private final DoubleProperty backgroundFade = new SimpleDoubleProperty(0.0);
    private final ObjectProperty<EventHandler<LifecycleEvent>> onShowing = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onShowing"){

        protected void invalidated() {
            Layer.this.setEventHandler(LifecycleEvent.SHOWING, (EventHandler)this.get());
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onShown = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onShown"){

        protected void invalidated() {
            Layer.this.setEventHandler(LifecycleEvent.SHOWN, (EventHandler)this.get());
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onHiding = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onHiding"){

        protected void invalidated() {
            Layer.this.setEventHandler(LifecycleEvent.HIDING, (EventHandler)this.get());
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onHidden = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onHidden"){

        protected void invalidated() {
            Layer.this.setEventHandler(LifecycleEvent.HIDDEN, (EventHandler)this.get());
        }
    };

    public Layer() {
        this.setPickOnBounds(false);
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showingProperty;
    }

    public final boolean isShowing() {
        return this.showingProperty.get();
    }

    public final BooleanProperty autoHideProperty() {
        return this.autoHide;
    }

    public final boolean isAutoHide() {
        return this.autoHide.get();
    }

    public final void setAutoHide(boolean value) {
        this.autoHide.set(value);
    }

    public final ObjectProperty<Function<Layer, Transition>> showTransitionFactoryProperty() {
        return this.showTransitionFactory;
    }

    public final Function<Layer, Transition> getShowTransitionFactory() {
        return (Function)this.showTransitionFactory.get();
    }

    public final void setShowTransitionFactory(Function<Layer, Transition> value) {
        this.showTransitionFactory.set(value);
    }

    public final ObjectProperty<Function<Layer, Transition>> hideTransitionFactoryProperty() {
        return this.hideTransitionFactory;
    }

    public final Function<Layer, Transition> getHideTransitionFactory() {
        return (Function)this.hideTransitionFactory.get();
    }

    public final void setHideTransitionFactory(Function<Layer, Transition> value) {
        this.hideTransitionFactory.set(value);
    }

    public final DoubleProperty backgroundFadeProperty() {
        return this.backgroundFade;
    }

    public final void setBackgroundFade(double level) {
        this.backgroundFade.set(level);
    }

    public final double getBackgroundFade() {
        return this.backgroundFade.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onShowingProperty() {
        return this.onShowing;
    }

    public final void setOnShowing(EventHandler<LifecycleEvent> value) {
        this.onShowing.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnShowing() {
        return (EventHandler)this.onShowing.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onShownProperty() {
        return this.onShown;
    }

    public final void setOnShown(EventHandler<LifecycleEvent> value) {
        this.onShown.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnShown() {
        return (EventHandler)this.onShown.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onHidingProperty() {
        return this.onHiding;
    }

    public final void setOnHiding(EventHandler<LifecycleEvent> value) {
        this.onHiding.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnHiding() {
        return (EventHandler)this.onHiding.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onHiddenProperty() {
        return this.onHidden;
    }

    public final void setOnHidden(EventHandler<LifecycleEvent> value) {
        this.onHidden.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnHidden() {
        return (EventHandler)this.onHidden.get();
    }

    public void show() {
        if (this.isShowing() || this.isAnimating()) {
            return;
        }
        Event.fireEvent((EventTarget)this, (Event)new LifecycleEvent((EventTarget)this, LifecycleEvent.SHOWING));
        this.requiresShowAnimation = true;
        ObservableList<Layer> layers = GlassPaneHelper.getLayers();
        if (!layers.contains((Object)this)) {
            if (layers.size() > 0) {
                this.parentLayer = (Layer)((Object)layers.get(layers.size() - 1));
            }
            layers.add((Object)this);
        }
        this.showingProperty.setValue(Boolean.valueOf(true));
    }

    public void hide() {
        if (!this.isShowing() || this.isAnimating()) {
            return;
        }
        this.requiresHideAnimation = true;
        Event.fireEvent((EventTarget)this, (Event)new LifecycleEvent((EventTarget)this, LifecycleEvent.HIDING));
        this.requestLayout();
    }

    public void layoutChildren() {
        if (this.requiresShowAnimation) {
            this.requiresShowAnimation = false;
            this.showTransition = this.getShowTransition();
            this.showTransition.statusProperty().addListener((ChangeListener)new ChangeListener<Animation.Status>(){

                public void changed(ObservableValue<? extends Animation.Status> observable, Animation.Status oldValue, Animation.Status newValue) {
                    if (newValue == Animation.Status.STOPPED) {
                        Event.fireEvent((EventTarget)Layer.this, (Event)new LifecycleEvent((EventTarget)Layer.this, LifecycleEvent.SHOWN));
                        Layer.this.showTransition.statusProperty().removeListener((ChangeListener)this);
                    }
                }
            });
            this.showTransition.play();
        }
        if (this.requiresHideAnimation) {
            this.requiresHideAnimation = false;
            this.hideTransition = this.getHideTransition();
            this.hideTransition.statusProperty().addListener((ChangeListener)new ChangeListener<Animation.Status>(){

                public void changed(ObservableValue<? extends Animation.Status> observable, Animation.Status oldValue, Animation.Status newValue) {
                    if (newValue == Animation.Status.STOPPED) {
                        Layer.this.showingProperty.setValue(Boolean.valueOf(false));
                        Event.fireEvent((EventTarget)Layer.this, (Event)new LifecycleEvent((EventTarget)Layer.this, LifecycleEvent.HIDDEN));
                        Layer.this.hideTransition.statusProperty().removeListener((ChangeListener)this);
                        if (GlassPaneHelper.isHideAllLayers() && Layer.this.parentLayer != null && Layer.this.parentLayer.isShowing()) {
                            Layer.this.parentLayer.hide();
                        }
                    }
                }
            });
            this.hideTransition.play();
        }
    }

    private Transition getShowTransition() {
        return Optional.ofNullable(this.getShowTransitionFactory()).map(function -> (Transition)function.apply(this)).orElse(new NoTransition());
    }

    private Transition getHideTransition() {
        return Optional.ofNullable(this.getHideTransitionFactory()).map(function -> (Transition)function.apply(this)).orElse(new NoTransition());
    }

    private boolean isAnimating() {
        return this.showTransition != null && this.showTransition.getStatus() == Animation.Status.RUNNING || this.hideTransition != null && this.hideTransition.getStatus() == Animation.Status.RUNNING;
    }
}

