/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.layout.layer;

import com.gluonhq.charm.glisten.animation.FadeInTransition;
import com.gluonhq.charm.glisten.animation.FadeOutTransition;
import com.gluonhq.charm.glisten.layout.Layer;
import com.gluonhq.impl.charm.glisten.control.skin.PopupRenderer;
import com.gluonhq.impl.charm.glisten.control.skin.util.PopupPlacementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.InsetsConverter;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class PopupView
extends Layer {
    private final Node ownerNode;
    private final PopupRenderer renderer;
    private final ScrollPane rootNode;
    private double originalRootWidth = -1.0;
    private double originalRootHeight = -1.0;
    private final DoubleProperty verticalOffset = new SimpleDoubleProperty(0.0);
    private final StyleableObjectProperty<Insets> popupPadding = new SimpleStyleableObjectProperty(POPUP_PADDING, (Object)this, "popupPadding", (Object)Insets.EMPTY);
    private final ObjectProperty<PopupSide> side = new SimpleObjectProperty((Object)this, "side", (Object)PopupSide.LEFT);
    private static final String DEFAULT_STYLE_CLASS = "popup-view";
    private static final CssMetaData<PopupView, Insets> POPUP_PADDING = new CssMetaData<PopupView, Insets>("-fx-popup-padding", InsetsConverter.getInstance(), Insets.EMPTY){

        public boolean isSettable(PopupView node) {
            return !node.popupPadding.isBound();
        }

        public StyleableProperty<Insets> getStyleableProperty(PopupView node) {
            return node.popupPaddingProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    protected PopupView(Node ownerNode, PopupRenderer renderer) {
        if (ownerNode == null) {
            throw new NullPointerException("Owner node can not be null");
        }
        this.ownerNode = ownerNode;
        this.renderer = renderer;
        this.rootNode = renderer.getRootNode();
        this.rootNode.setOpacity(0.0);
        this.getChildren().add((Object)this.rootNode);
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setShowTransitionFactory(layer -> {
            FadeInTransition fadeInTransition = new FadeInTransition((Node)this.rootNode, Duration.millis((double)250.0));
            fadeInTransition.setDelay(Duration.ZERO);
            return fadeInTransition;
        });
        this.setHideTransitionFactory(layer -> {
            FadeOutTransition fadeInTransition = new FadeOutTransition((Node)this.rootNode, Duration.millis((double)250.0));
            fadeInTransition.setDelay(Duration.ZERO);
            fadeInTransition.setOnFinished(e -> this.rootNode.setOpacity(0.0));
            return fadeInTransition;
        });
        this.initializeListeners();
    }

    private void initializeListeners() {
        this.contentProperty().addListener(o -> this.requestLayout());
        this.sideProperty().addListener(o -> this.requestLayout());
        this.popupPaddingProperty().addListener(o -> this.requestLayout());
        this.verticalOffsetProperty().addListener(o -> this.requestLayout());
    }

    public PopupView(@NamedArg(value="ownerNode") Node ownerNode) {
        this(ownerNode, new PopupRenderer());
    }

    public PopupView(Node ownerNode, Node content) {
        this(ownerNode);
        this.setContent(content);
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.renderer.contentProperty();
    }

    public final void setContent(Node content) {
        this.renderer.setContent(content);
    }

    public final Node getContent() {
        return this.renderer.getContent();
    }

    public final void setVerticalOffset(double offset) {
        this.verticalOffset.set(offset);
    }

    public double getVerticalOffset() {
        return this.verticalOffset.get();
    }

    public DoubleProperty verticalOffsetProperty() {
        return this.verticalOffset;
    }

    public final StyleableObjectProperty<Insets> popupPaddingProperty() {
        return this.popupPadding;
    }

    public final Insets getPopupPadding() {
        return (Insets)this.popupPadding.get();
    }

    public final void setPopupPadding(Insets value) {
        this.popupPadding.set((Object)value);
    }

    public final ObjectProperty<PopupSide> sideProperty() {
        return this.side;
    }

    public final PopupSide getSide() {
        return (PopupSide)((Object)this.side.get());
    }

    public final void setSide(PopupSide value) {
        this.side.set((Object)value);
    }

    @Override
    public void layoutChildren() {
        boolean isShowing = this.isShowing();
        if (!isShowing) {
            return;
        }
        if (!this.useContentSize()) {
            this.originalRootHeight = -1.0;
            this.originalRootWidth = -1.0;
        }
        Scene scene = this.ownerNode.getScene();
        double sceneWidth = scene.getWidth();
        double sceneHeight = scene.getHeight();
        double width = this.originalRootWidth == -1.0 ? this.rootNode.prefWidth(-1.0) : this.originalRootWidth;
        double height = this.originalRootHeight == -1.0 ? this.rootNode.prefHeight(width) : this.originalRootHeight;
        width = this.getPrefWidth() > 0.0 ? this.getPrefWidth() : width;
        height = this.getPrefHeight() > 0.0 ? this.getPrefHeight() : height;
        this.rootNode.resize(width, height);
        if (this.originalRootWidth == -1.0) {
            this.originalRootWidth = width;
        }
        if (this.originalRootHeight == -1.0) {
            this.originalRootHeight = height;
        }
        Point2D pos = PopupPlacementUtils.calculatePopupPosition(this.ownerNode, (Node)this.rootNode, this.getPopupPadding(), this.getSide(), this.getVerticalOffset());
        double positionX = pos.getX();
        double positionY = pos.getY();
        double bottomPadding = this.getPopupPadding().getBottom();
        Bounds b = this.ownerNode.getLocalToSceneTransform().transform(this.ownerNode.getLayoutBounds());
        double rightPadding = this.getPopupPadding().getRight();
        if (positionX + width + rightPadding > sceneWidth) {
            width = sceneWidth - positionX - rightPadding;
            height = this.rootNode.prefHeight(width);
        }
        if (pos.getY() >= b.getMinY()) {
            height = Math.min(height, sceneHeight - b.getMinY() - bottomPadding - this.getVerticalOffset());
        } else {
            if (pos.getY() < this.getPopupPadding().getTop()) {
                positionY = this.getPopupPadding().getTop();
            }
            height = Math.min(height, Math.min(b.getMaxY(), sceneHeight - bottomPadding) - this.getPopupPadding().getTop() - this.getVerticalOffset());
        }
        width = Math.max(this.getMinWidth(), this.getMaxWidth() > 0.0 ? Math.min(width, this.getMaxWidth()) : width);
        height = Math.max(this.getMinHeight(), this.getMaxHeight() > 0.0 ? Math.min(height, this.getMaxHeight()) : height);
        this.rootNode.resizeRelocate(positionX, positionY, width, height);
        super.layoutChildren();
    }

    protected boolean useContentSize() {
        return true;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return PopupView.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<PopupView, Insets>> styleables = new ArrayList<CssMetaData<PopupView, Insets>>(Region.getClassCssMetaData());
        styleables.add(POPUP_PADDING);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public static enum PopupSide {
        LEFT,
        RIGHT;

    }
}

