/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.layout.layer;

import com.gluonhq.charm.glisten.animation.FadeInDownBigTransition;
import com.gluonhq.charm.glisten.animation.FadeInLeftBigTransition;
import com.gluonhq.charm.glisten.animation.FadeInRightBigTransition;
import com.gluonhq.charm.glisten.animation.FadeInUpBigTransition;
import com.gluonhq.charm.glisten.animation.FadeOutDownBigTransition;
import com.gluonhq.charm.glisten.animation.FadeOutLeftBigTransition;
import com.gluonhq.charm.glisten.animation.FadeOutRightBigTransition;
import com.gluonhq.charm.glisten.animation.FadeOutUpBigTransition;
import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.GlassPane;
import com.gluonhq.charm.glisten.layout.Layer;
import javafx.animation.Transition;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.util.Duration;

public class SidePopupView
extends Layer {
    private static final double DEFAULT_BACKGROUND_FADE_LEVEL = 0.5;
    private static final Duration DEFAULT_DURATION = Duration.millis((double)600.0);
    private Node content;
    private GlassPane glassPane = null;
    private final ObjectProperty<Side> sideProperty = new SimpleObjectProperty((Object)Side.LEFT);

    public SidePopupView(@NamedArg(value="content") Node content) {
        this(content, Side.LEFT, true);
    }

    public SidePopupView(@NamedArg(value="content") Node content, @NamedArg(value="side") Side side, @NamedArg(value="fadeRequired") Boolean fadeRequired) {
        AppManager mobileApplication;
        this.content = content;
        this.setSide(side);
        if (content != null) {
            this.getChildren().add((Object)content);
        }
        if ((mobileApplication = AppManager.getInstance()) != null) {
            this.glassPane = mobileApplication.getGlassPane();
        }
        this.setShowTransitionFactory(layer -> {
            Transition showTransition = this.createShowTransition(content);
            showTransition.setDelay(Duration.ZERO);
            if (fadeRequired.booleanValue()) {
                showTransition.currentTimeProperty().addListener(o -> {
                    double frac = showTransition.getCurrentTime().toMillis() / showTransition.getCycleDuration().toMillis();
                    double backgroundFade = 0.5 * frac;
                    this.setBackgroundFade(backgroundFade);
                });
            }
            return showTransition;
        });
        this.setHideTransitionFactory(layer -> {
            Transition hideTransition = this.createHideTransition(content);
            hideTransition.setDelay(Duration.ZERO);
            if (fadeRequired.booleanValue()) {
                hideTransition.currentTimeProperty().addListener(o -> {
                    double frac = hideTransition.getCurrentTime().toMillis() / hideTransition.getCycleDuration().toMillis();
                    double backgroundFade = 0.5 * (1.0 - frac);
                    this.setBackgroundFade(backgroundFade);
                });
            }
            return hideTransition;
        });
        this.setOnSwipeLeft(e -> this.hide());
        this.addEventHandler(AppManager.MobileEvent.BACK_BUTTON_PRESSED, event -> {
            this.hide();
            event.consume();
        });
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.sideProperty;
    }

    public final void setSide(Side side) {
        this.sideProperty.set((Object)side);
    }

    public final Side getSide() {
        return (Side)this.sideProperty.get();
    }

    @Override
    public void layoutChildren() {
        double prefWidth;
        double prefHeight;
        boolean isShowing = this.isShowing();
        this.content.setVisible(isShowing);
        if (!isShowing) {
            return;
        }
        if (this.glassPane == null) {
            this.glassPane = AppManager.getInstance().getGlassPane();
        }
        double x = 0.0;
        double y = 0.0;
        switch (this.getSide()) {
            default: {
                prefHeight = this.glassPane.getHeight();
                prefWidth = this.content.prefWidth(prefHeight);
                break;
            }
            case RIGHT: {
                prefHeight = this.glassPane.getHeight();
                prefWidth = this.content.prefWidth(prefHeight);
                x = this.glassPane.getWidth() - prefWidth;
                break;
            }
            case TOP: {
                prefWidth = this.glassPane.getWidth();
                prefHeight = this.content.prefHeight(prefWidth);
                break;
            }
            case BOTTOM: {
                prefWidth = this.glassPane.getWidth();
                prefHeight = this.content.prefHeight(prefWidth);
                y = this.glassPane.getHeight() - prefHeight;
            }
        }
        this.content.resizeRelocate(x, y, prefWidth, prefHeight);
        super.layoutChildren();
    }

    protected double computePrefWidth(double height) {
        return this.snappedLeftInset() + this.content.prefWidth(height) + this.snappedRightInset();
    }

    protected double computePrefHeight(double width) {
        return this.snappedTopInset() + this.content.prefHeight(width) + this.snappedBottomInset();
    }

    private Transition createShowTransition(Node content) {
        switch (this.getSide()) {
            case TOP: {
                return new FadeInDownBigTransition(content, false, DEFAULT_DURATION);
            }
            case RIGHT: {
                return new FadeInRightBigTransition(content, false, DEFAULT_DURATION);
            }
            case BOTTOM: {
                return new FadeInUpBigTransition(content, false, DEFAULT_DURATION);
            }
        }
        return new FadeInLeftBigTransition(content, false, DEFAULT_DURATION);
    }

    private Transition createHideTransition(Node content) {
        switch (this.getSide()) {
            case TOP: {
                return new FadeOutUpBigTransition(content, false, DEFAULT_DURATION);
            }
            case RIGHT: {
                return new FadeOutRightBigTransition(content, false, DEFAULT_DURATION);
            }
            case BOTTOM: {
                return new FadeOutDownBigTransition(content, false, DEFAULT_DURATION);
            }
        }
        return new FadeOutLeftBigTransition(content, false, DEFAULT_DURATION);
    }
}

