/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.layout.responsive.grid;

import com.gluonhq.charm.glisten.layout.responsive.grid.GridSpan;
import javafx.beans.DefaultProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;

@DefaultProperty(value="spans")
public class GridRow
extends Region {
    private static final int MAX_COLUMNS = 12;
    GridSpan parentSpan;
    private final ObservableList<GridSpan> spans;
    private int wrappedRowCount = 1;

    public GridRow() {
        this(null);
    }

    public GridRow(GridSpan ... elements) {
        this.getStyleClass().add((Object)"grid-row");
        this.spans = FXCollections.observableArrayList();
        this.spans.addListener(c -> {
            this.getChildren().setAll(this.spans);
            for (GridSpan span : this.spans) {
                span.parentRow = this;
            }
        });
        if (elements != null) {
            this.spans.addAll((Object[])elements);
        }
    }

    public final ObservableList<GridSpan> getSpans() {
        return this.spans;
    }

    protected void layoutChildren() {
        double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double h = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double x = this.snappedLeftInset();
        double y = this.snappedTopInset();
        double startX = x;
        double startY = y;
        if (this.isStackSpansVertically()) {
            int max = this.spans.size();
            for (int i = 0; i < max; ++i) {
                GridSpan span = (GridSpan)((Object)this.spans.get(i));
                double nodeHeight = span.prefHeight(w);
                span.resizeRelocate(x, startY, w, nodeHeight);
                startY += nodeHeight;
            }
        } else {
            double widthPerColumn = w / 12.0;
            double heightPerRow = (h - startY) / (double)this.wrappedRowCount;
            int spanCount = 0;
            int max = this.spans.size();
            for (int i = 0; i < max; ++i) {
                int offset;
                GridSpan spanNode = (GridSpan)((Object)this.spans.get(i));
                int span = spanNode.getSpan().getSpan();
                if (spanCount + span + (offset = spanNode.getOffset().getOffset()) > 12) {
                    spanCount = 0;
                    startX = 0.0;
                    startY += heightPerRow;
                } else {
                    spanCount += span + offset;
                    startX += (double)offset * widthPerColumn;
                }
                double nodeWidth = (double)span * widthPerColumn;
                spanNode.resizeRelocate(startX, startY, nodeWidth, heightPerRow);
                startX += nodeWidth;
            }
        }
    }

    protected double computePrefHeight(double width) {
        boolean stackSpansVertically = this.isStackSpansVertically();
        double widthPerColumn = width / 12.0;
        double result = 0.0;
        int spanCount = 0;
        this.wrappedRowCount = 1;
        int max = this.spans.size();
        for (int i = 0; i < max; ++i) {
            GridSpan spanNode = (GridSpan)((Object)this.spans.get(i));
            int span = spanNode.getSpan().getSpan();
            int offset = spanNode.getOffset().getOffset();
            double nodeWidth = stackSpansVertically ? width : (double)span * widthPerColumn;
            double nodeHeight = spanNode.prefHeight(nodeWidth);
            if (stackSpansVertically) {
                result += nodeHeight;
                continue;
            }
            if (spanCount + span + offset > 12) {
                spanCount = 0;
                ++this.wrappedRowCount;
                continue;
            }
            spanCount += span + offset;
            result = Math.max(result, nodeHeight);
        }
        return result * (double)this.wrappedRowCount + this.snappedTopInset() + this.snappedBottomInset();
    }

    protected double computeMaxHeight(double width) {
        return this.computePrefHeight(width);
    }

    boolean isStackSpansVertically() {
        if (this.parentSpan == null) {
            throw new IllegalStateException("parentSpan should never be null");
        }
        return this.parentSpan.isStackSpansVertically();
    }
}

