/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.layout.responsive.grid;

import com.gluonhq.charm.glisten.layout.responsive.grid.GridRow;
import com.gluonhq.charm.glisten.layout.responsive.grid.Offset;
import com.gluonhq.charm.glisten.layout.responsive.grid.Span;
import javafx.beans.DefaultProperty;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;

@DefaultProperty(value="content")
public class GridSpan
extends Region {
    GridRow parentRow;
    private final Span span;
    private final Offset offset;
    private final GridRow spanRow;
    private final ObservableList<GridRow> nestedRows;
    private final ObjectProperty<Node> contentProperty = new SimpleObjectProperty<Node>((Object)this, "content"){

        protected void invalidated() {
            GridSpan.this.updateChildren();
        }
    };

    public GridSpan(@NamedArg(value="span") Span span) {
        this(span, null);
    }

    public GridSpan(@NamedArg(value="span") Span span, Node content) {
        this(span, Offset.OFFSET_0, content);
    }

    public GridSpan(@NamedArg(value="span") Span span, @NamedArg(value="offset") Offset offset, @NamedArg(value="content") Node content) {
        this(span, offset, content, null);
    }

    public GridSpan(@NamedArg(value="span") Span span, @NamedArg(value="offset") Offset offset, Node content, GridSpan ... elements) {
        this.getStyleClass().add((Object)"grid-span");
        this.span = span == null ? Span.SPAN_1 : span;
        this.offset = offset == null ? Offset.OFFSET_0 : offset;
        this.nestedRows = FXCollections.observableArrayList();
        this.nestedRows.addListener(c -> this.updateChildren());
        this.spanRow = new GridRow(elements);
        this.spanRow.parentSpan = this;
        this.setContent(content);
        this.updateChildren();
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.contentProperty;
    }

    public final Node getContent() {
        return (Node)this.contentProperty.get();
    }

    public final void setContent(Node value) {
        this.contentProperty.set((Object)value);
    }

    public final Span getSpan() {
        return this.span;
    }

    public final Offset getOffset() {
        return this.offset;
    }

    public final ObservableList<GridSpan> getSpans() {
        return this.spanRow.getSpans();
    }

    public final ObservableList<GridRow> getNestedRows() {
        return this.nestedRows;
    }

    protected void layoutChildren() {
        double y;
        double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double h = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double x = this.snappedLeftInset();
        double startY = y = this.snappedTopInset();
        Node content = this.getContent();
        if (content != null) {
            double contentPrefHeight = Math.max(content.minHeight(w), content.prefHeight(w));
            content.resizeRelocate(x, y, w, contentPrefHeight);
            startY += contentPrefHeight;
        }
        double spansPrefHeight = this.spanRow.prefHeight(w);
        this.spanRow.resizeRelocate(x, startY, w, spansPrefHeight);
        startY += spansPrefHeight;
        int max = this.nestedRows.size();
        for (int i = 0; i < max; ++i) {
            GridRow childCell = (GridRow)((Object)this.nestedRows.get(i));
            double ph = childCell.prefHeight(w);
            childCell.resizeRelocate(x, startY, w, ph);
            startY += ph;
        }
    }

    protected double computePrefHeight(double width) {
        double w = width - (this.snappedLeftInset() + this.snappedRightInset());
        Node content = this.getContent();
        double contentPrefHeight = content == null ? 0.0 : Math.max(content.minHeight(w), content.prefHeight(w));
        double spansPrefHeight = this.spanRow.computePrefHeight(w);
        double rowsPrefHeight = 0.0;
        int max = this.nestedRows.size();
        for (int i = 0; i < max; ++i) {
            GridRow childCell = (GridRow)((Object)this.nestedRows.get(i));
            rowsPrefHeight += childCell.prefHeight(w);
        }
        return contentPrefHeight + spansPrefHeight + rowsPrefHeight + this.snappedTopInset() + this.snappedBottomInset();
    }

    protected double computeMaxHeight(double width) {
        return this.computePrefHeight(width);
    }

    private void updateChildren() {
        this.getChildren().clear();
        if (this.getContent() != null) {
            this.getChildren().addAll((Object[])new Node[]{this.getContent()});
        }
        this.getChildren().add((Object)this.spanRow);
        this.getChildren().addAll(this.nestedRows);
        for (GridRow gridRow : this.nestedRows) {
            gridRow.parentSpan = this;
        }
    }

    boolean isStackSpansVertically() {
        if (this.parentRow == null) {
            double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            return w < 767.0;
        }
        return this.parentRow.isStackSpansVertically();
    }
}

