/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.mvc;

import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.control.AppBar;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import com.gluonhq.charm.glisten.mvc.View;
import javafx.animation.PauseTransition;
import javafx.beans.NamedArg;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import javafx.util.Duration;

public class SplashView
extends View {
    private final ReadOnlyStringProperty nextView;
    private final ReadOnlyObjectProperty<Duration> duration;

    public SplashView() {
        this("home", null, null);
    }

    public SplashView(@NamedArg(value="nextView") String nextView) {
        this(nextView, null, null);
    }

    public SplashView(@NamedArg(value="content") Node content) {
        this("home", content, null);
    }

    public SplashView(@NamedArg(value="nextView") String nextView, @NamedArg(value="content") Node content) {
        this(nextView, content, null);
    }

    public SplashView(@NamedArg(value="nextView") String nextView, @NamedArg(value="content") Node content, @NamedArg(value="duration") Duration duration) {
        super(content);
        this.getStyleClass().add((Object)"splash-view");
        this.nextView = new SimpleStringProperty(nextView);
        this.duration = new SimpleObjectProperty((Object)duration);
        this.addEventHandler(LifecycleEvent.HIDDEN, e -> AppManager.getInstance().removeViewFactory("splash"));
        if (this.getDuration() != null) {
            this.addEventHandler(LifecycleEvent.SHOWN, e -> this.defaultTransitionEventHandler());
        }
    }

    public final String getNextView() {
        return (String)this.nextView.get();
    }

    public final ReadOnlyStringProperty nextViewProperty() {
        return this.nextView;
    }

    public final Duration getDuration() {
        return (Duration)this.duration.get();
    }

    public final ReadOnlyObjectProperty<Duration> durationProperty() {
        return this.duration;
    }

    public void hideSplashView() {
        AppManager.getInstance().switchView(this.getNextView() != null ? this.getNextView() : "home");
    }

    @Override
    protected void updateAppBar(AppBar appBar) {
        appBar.setVisible(false);
    }

    private void defaultTransitionEventHandler() {
        PauseTransition pause = new PauseTransition(this.getDuration());
        pause.setOnFinished(e -> this.hideSplashView());
        pause.play();
    }
}

