/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.mvc;

import com.gluonhq.charm.glisten.animation.MobileTransition;
import com.gluonhq.charm.glisten.animation.NoTransition;
import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.MobileApplication;
import com.gluonhq.charm.glisten.control.AppBar;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.BorderPane;

@DefaultProperty(value="center")
public class View
extends BorderPane {
    private final ReadOnlyBooleanWrapper showingProperty = new ReadOnlyBooleanWrapper((Object)this, "showing", false);
    private final ObjectProperty<Function<View, MobileTransition>> showTransitionFactoryProperty = new SimpleObjectProperty((Object)this, "showTransitionFactory");
    private final ObjectProperty<EventHandler<LifecycleEvent>> onShowing = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onShowing"){

        protected void invalidated() {
            View.this.setEventHandler(LifecycleEvent.SHOWING, (EventHandler)this.get());
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onShown = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onShown"){

        protected void invalidated() {
            View.this.setEventHandler(LifecycleEvent.SHOWN, (EventHandler)this.get());
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onHiding = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onHiding"){

        protected void invalidated() {
            View.this.setEventHandler(LifecycleEvent.HIDING, (EventHandler)this.get());
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onHidden = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onHidden"){

        protected void invalidated() {
            View.this.setEventHandler(LifecycleEvent.HIDDEN, (EventHandler)this.get());
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onCloseRequest = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onCloseRequest"){

        protected void invalidated() {
            View.this.setEventHandler(LifecycleEvent.CLOSE_REQUEST, (EventHandler)this.get());
        }
    };

    public View() {
        this(null);
    }

    public View(Node content) {
        super(content);
        this.getStyleClass().setAll((Object[])new String[]{"view"});
        this.addEventHandler(LifecycleEvent.SHOWING, event -> this.onShowing());
        this.addEventHandler(LifecycleEvent.HIDDEN, event -> this.onHidden());
        this.addEventHandler(LifecycleEvent.HIDING, event -> this.requestFocus());
    }

    private void onHidden() {
        this.showingProperty.set(false);
        if (this.getScene().getFocusOwner() instanceof TextInputControl) {
            this.requestFocus();
        }
    }

    private void onShowing() {
        AppBar appBar = AppManager.getInstance().getAppBar();
        if (appBar != null) {
            appBar.clear();
            this.updateAppBar(appBar);
        }
        this.showingProperty.set(true);
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showingProperty.getReadOnlyProperty();
    }

    public final boolean isShowing() {
        return this.showingProperty.get();
    }

    public final ObjectProperty<Function<View, MobileTransition>> showTransitionFactoryProperty() {
        return this.showTransitionFactoryProperty;
    }

    public final Function<View, MobileTransition> getShowTransitionFactory() {
        return (Function)this.showTransitionFactoryProperty.get();
    }

    public final void setShowTransitionFactory(Function<View, MobileTransition> value) {
        this.showTransitionFactoryProperty.set(value);
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onShowingProperty() {
        return this.onShowing;
    }

    public final void setOnShowing(EventHandler<LifecycleEvent> value) {
        this.onShowing.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnShowing() {
        return (EventHandler)this.onShowing.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onShownProperty() {
        return this.onShown;
    }

    public final void setOnShown(EventHandler<LifecycleEvent> value) {
        this.onShown.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnShown() {
        return (EventHandler)this.onShown.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onHidingProperty() {
        return this.onHiding;
    }

    public final void setOnHiding(EventHandler<LifecycleEvent> value) {
        this.onHiding.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnHiding() {
        return (EventHandler)this.onHiding.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onHiddenProperty() {
        return this.onHidden;
    }

    public final void setOnHidden(EventHandler<LifecycleEvent> value) {
        this.onHidden.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnHidden() {
        return (EventHandler)this.onHidden.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onCloseRequestProperty() {
        return this.onCloseRequest;
    }

    public final void setOnCloseRequest(EventHandler<LifecycleEvent> value) {
        this.onCloseRequest.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnCloseRequest() {
        return (EventHandler)this.onCloseRequest.get();
    }

    public MobileTransition getShowTransition() {
        return Optional.ofNullable(this.getShowTransitionFactory()).map(factory -> (MobileTransition)((Object)((Object)factory.apply(this)))).orElse(new NoTransition());
    }

    protected void updateAppBar(AppBar appBar) {
    }

    @Deprecated
    public final MobileApplication getApplication() {
        return MobileApplication.getInstance();
    }

    public final AppManager getAppManager() {
        return AppManager.getInstance();
    }
}

