/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.visual;

import com.gluonhq.charm.glisten.visual.SwatchElement;
import com.gluonhq.impl.charm.glisten.util.StylesheetTools;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javafx.scene.Scene;
import javafx.scene.paint.Color;

public enum Swatch {
    BLUE,
    CYAN,
    DEEP_ORANGE,
    DEEP_PURPLE,
    GREEN,
    INDIGO,
    LIGHT_BLUE,
    PINK,
    PURPLE,
    RED,
    TEAL,
    LIGHT_GREEN,
    LIME,
    YELLOW,
    AMBER,
    ORANGE,
    BROWN,
    GREY,
    BLUE_GREY;

    private static final String SWATCH_PREFIX = "swatch_";
    private final String stylesheetName = StylesheetTools.buildResourceName("swatch_", this.name());
    private Map<String, Color> colors = null;
    private static final Random RANDOM;

    public void assignTo(Scene scene) {
        StylesheetTools.replaceStylesheet(scene, SWATCH_PREFIX, this.name());
    }

    private Map<String, Color> parseCss() {
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        try (InputStream is = StylesheetTools.asResourceStream(this.stylesheetName);){
            String line;
            BufferedReader lineReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = lineReader.readLine()) != null) {
                if (!(line = line.trim()).contains("-swatch-") || !line.endsWith(";")) continue;
                String[] pair = line.replace(";", "").split(":");
                pair[0] = pair[0].trim().toLowerCase();
                pair[1] = pair[1].trim().toLowerCase();
                if (!pair[1].startsWith("#")) continue;
                hashMap.put(pair[0], Color.web((String)pair[1]));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return hashMap;
    }

    public Color getColor(SwatchElement element) {
        if (this.colors == null) {
            this.colors = this.parseCss();
        }
        return this.colors.get(element.getTitle());
    }

    public static Swatch getDefault() {
        return BLUE;
    }

    public static Swatch getRandom() {
        return Swatch.values()[RANDOM.nextInt(Swatch.values().length)];
    }

    static {
        RANDOM = new Random();
    }
}

