/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.animation;

import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.scene.Node;
import javafx.util.Duration;

public final class LayoutTransition
extends Transition {
    private final Node n;
    private double startX;
    private double startY;
    private double endX;
    private double endY;

    public LayoutTransition(Duration d, Node n) {
        this.setCycleDuration(d);
        this.setCycleCount(1);
        this.n = n;
        this.statusProperty().addListener(o -> {
            if (this.getStatus() == Animation.Status.RUNNING) {
                this.startX = n.getLayoutX();
                this.startY = n.getLayoutY();
            }
        });
    }

    public void setEndX(double value) {
        this.endX = value;
    }

    public void setEndY(double value) {
        this.endY = value;
    }

    protected void interpolate(double frac) {
        double deltaX = this.endX - this.startX;
        double deltaY = this.endY - this.startY;
        this.n.setLayoutX(this.startX + deltaX * frac);
        this.n.setLayoutY(this.startY + deltaY * frac);
    }
}

