/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.control.skin;

import com.gluonhq.impl.charm.glisten.control.skin.PopupRenderer;
import java.util.Collection;
import java.util.HashMap;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;

public class MenuRenderer
extends PopupRenderer {
    private final VBox vBox = new VBox();
    private final HashMap<MenuItem, Node> menuItemToNode;

    public MenuRenderer(Menu menu) {
        this.setContent((Node)this.vBox);
        this.getRootNode().getStyleClass().setAll((Object[])new String[]{"menu"});
        this.menuItemToNode = new HashMap();
        for (MenuItem menuItem : menu.getItems()) {
            Node node = MenuRenderer.createMenuItem(menu, menuItem);
            this.menuItemToNode.put(menuItem, node);
            this.vBox.getChildren().add((Object)node);
        }
        menu.getItems().addListener(c -> this.menuItemsChanged(menu, this.vBox, (ListChangeListener.Change<? extends MenuItem>)c));
    }

    private void menuItemsChanged(Menu menu, VBox vbox, ListChangeListener.Change<? extends MenuItem> c) {
        while (c.next()) {
            if (c.wasAdded()) {
                for (MenuItem item : c.getAddedSubList()) {
                    Node node = MenuRenderer.createMenuItem(menu, item);
                    this.menuItemToNode.put(item, node);
                    vbox.getChildren().add((Object)node);
                }
            }
            if (!c.wasRemoved()) continue;
            for (MenuItem item : c.getRemoved()) {
                vbox.getChildren().remove((Object)this.menuItemToNode.get(item));
                this.menuItemToNode.remove(item);
            }
        }
    }

    private static Node createMenuItem(Menu menu, MenuItem menuItem) {
        if (menuItem instanceof CheckMenuItem) {
            CheckBox check = MenuRenderer.bindMenuItem(menu, menuItem, new CheckBox());
            check.selectedProperty().bindBidirectional((Property)((CheckMenuItem)menuItem).selectedProperty());
            return check;
        }
        if (menuItem instanceof RadioMenuItem) {
            RadioButton radio = MenuRenderer.bindMenuItem(menu, menuItem, new RadioButton());
            radio.selectedProperty().bindBidirectional((Property)((RadioMenuItem)menuItem).selectedProperty());
            return radio;
        }
        return MenuRenderer.bindMenuItem(menu, menuItem, new Label());
    }

    private static <T extends Labeled> T bindMenuItem(Menu menu, MenuItem menuItem, T labeled) {
        labeled.getStyleClass().addAll((Collection)menuItem.getStyleClass());
        labeled.disableProperty().bind((ObservableValue)menuItem.disableProperty());
        labeled.textProperty().bind((ObservableValue)menuItem.textProperty());
        labeled.graphicProperty().bind((ObservableValue)menuItem.graphicProperty());
        labeled.setMaxWidth(Double.MAX_VALUE);
        labeled.setWrapText(true);
        labeled.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            menuItem.fire();
            menu.hide();
        });
        return labeled;
    }
}

