/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.application.AppManager;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;

public class PopupRenderer {
    private final ScrollPane rootNode;
    private final BorderPane container;
    private final ObjectProperty<Node> content = new SimpleObjectProperty<Node>(){

        protected void invalidated() {
            PopupRenderer.this.container.setCenter((Node)this.get());
        }
    };

    public PopupRenderer() {
        this.container = new BorderPane();
        this.container.getStyleClass().setAll((Object[])new String[]{"container"});
        this.rootNode = new ScrollPane((Node)this.container){

            protected double computePrefWidth(double height) {
                double width = super.computePrefWidth(height);
                double glassPaneWidth = AppManager.getInstance().getGlassPane().getWidth();
                return glassPaneWidth > width ? width : glassPaneWidth;
            }

            protected double computePrefHeight(double width) {
                double height = super.computePrefHeight(width);
                double glassPaneHeight = AppManager.getInstance().getGlassPane().getHeight();
                return glassPaneHeight > height ? height : glassPaneHeight;
            }
        };
        this.rootNode.setFitToWidth(true);
        this.rootNode.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.rootNode.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.rootNode.getStyleClass().setAll((Object[])new String[]{"root-node"});
    }

    public final void setContent(Node content) {
        this.content.set((Object)content);
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setPrefWidth(double width) {
        this.container.setPrefWidth(width);
    }

    public ScrollPane getRootNode() {
        return this.rootNode;
    }
}

