/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.control.skin;

import com.gluonhq.charm.glisten.control.ProgressIndicator;
import com.gluonhq.impl.charm.glisten.control.RefreshIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;

public class RefreshIndicatorSkin
extends SkinBase<RefreshIndicator> {
    private StyleableObjectProperty<Paint> color = new SimpleStyleableObjectProperty(COLOR, (Object)this, "color", (Object)Paint.valueOf((String)"#3C87EE"));
    private static final int CIRCLE_RADIUS_DELTA = 10;
    private static final int ROTATION_SPEED = 60;
    private ProgressIndicator progressIndicator;
    private Circle circle;
    private Circle gCircle;
    private Path path;
    private final Group group;
    private double arcLength = 300.0;
    private double arcRadius = 0.0;
    private double arcAngle = 0.0;
    private static final String DEFAULT_COLOR = "#3C87EE";
    private static final CssMetaData<RefreshIndicator, Paint> COLOR = new CssMetaData<RefreshIndicator, Paint>("-fx-color", PaintConverter.getInstance(), Paint.valueOf((String)"#3C87EE")){

        public boolean isSettable(RefreshIndicator node) {
            RefreshIndicatorSkin skin = (RefreshIndicatorSkin)node.getSkin();
            return skin.color == null || !skin.color.isBound();
        }

        public StyleableProperty<Paint> getStyleableProperty(RefreshIndicator node) {
            RefreshIndicatorSkin skin = (RefreshIndicatorSkin)node.getSkin();
            return skin.color;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public RefreshIndicatorSkin(RefreshIndicator control) {
        super((Control)control);
        double radius;
        this.arcRadius = radius = control.getRadius();
        this.circle = new Circle(radius + 10.0, (Paint)Color.WHITE);
        this.circle.getStyleClass().setAll((Object[])new String[]{"circle"});
        this.progressIndicator = new ProgressIndicator();
        this.progressIndicator.setRadius(radius);
        this.path = new Path();
        this.path.setStroke((Paint)this.color.getValue());
        this.path.setFill((Paint)this.color.getValue());
        this.gCircle = new Circle(radius + 10.0, (Paint)Color.TRANSPARENT);
        if (control.getMode() == RefreshIndicator.Mode.REFRESHING) {
            this.applyRefreshingMode();
        } else {
            this.applyPullingMode();
        }
        control.radiusProperty().addListener(ov -> {
            double newRadius;
            this.arcRadius = newRadius = control.getRadius();
            this.progressIndicator.setRadius(newRadius);
            this.circle.setRadius(newRadius + 10.0);
            this.gCircle.setRadius(newRadius + 10.0);
            control.requestLayout();
        });
        this.color.addListener((ov, oldValue, newValue) -> {
            if (newValue != null) {
                this.path.setStroke(newValue);
                this.path.setFill(newValue);
                this.progressIndicator.setStyle("-fx-color: #" + Integer.toHexString(((Paint)this.color.get()).hashCode()) + ";");
            }
        });
        this.group = new Group(new Node[]{this.gCircle, this.path, this.progressIndicator});
        this.getChildren().addAll((Object[])new Node[]{this.circle, this.group});
        control.pullProgressProperty().addListener((observable, oldValue, newValue) -> {
            this.updateLengthAndAngle(newValue.doubleValue());
            this.updatePath();
        });
        control.modeProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == RefreshIndicator.Mode.REFRESHING) {
                this.applyRefreshingMode();
            } else {
                this.applyPullingMode();
            }
        });
        this.progressIndicator.progressProperty().bind((ObservableValue)control.progressProperty());
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double centerX = this.snapSize(x + w / 2.0);
        double centerY = this.snapSize(y + h / 2.0);
        this.circle.setCenterX(centerX);
        this.circle.setCenterY(centerY);
        double startX = this.snapSize(centerX - this.group.getBoundsInLocal().getWidth() / 2.0);
        double startY = this.snapSize(centerY - this.group.getBoundsInLocal().getHeight() / 2.0);
        if (((RefreshIndicator)this.getSkinnable()).getMode() == RefreshIndicator.Mode.REFRESHING) {
            this.group.relocate(startX + 1.0, startY + 1.0);
        } else {
            this.group.relocate(startX, startY);
        }
    }

    private void updateLengthAndAngle(double value) {
        if (value < 1.0) {
            this.path.setOpacity(0.2);
            this.arcLength = -(value / 1.0 * 320.0);
            this.arcAngle = -value * 60.0;
        } else {
            this.path.setOpacity(1.0);
            this.arcAngle = -value * 50.0;
        }
    }

    private void updatePath() {
        double length = Math.abs(this.arcLength);
        double arrowLength = length > 30.0 ? 30.0 : length;
        double arrowWidth = length > 30.0 ? 30.0 : length;
        double ta = Math.tan(Math.toRadians(arrowLength));
        double t1 = Math.toRadians(arrowWidth);
        double wA = length > 30.0 ? this.arcRadius / 6.0 : this.arcRadius / 6.0 * length / 30.0;
        double x0 = (this.arcRadius - wA / 2.0) * Math.cos(Math.toRadians(this.arcAngle));
        double y0 = -(this.arcRadius - wA / 2.0) * Math.sin(Math.toRadians(this.arcAngle));
        double angle = this.arcLength + this.arcAngle;
        double x1 = (this.arcRadius - wA / 2.0) * Math.cos(Math.toRadians(angle + arrowLength));
        double y1 = -(this.arcRadius - wA / 2.0) * Math.sin(Math.toRadians(angle + arrowLength));
        double x2 = this.arcRadius * Math.cos(Math.toRadians(angle + arrowLength)) * (1.0 - t1 * ta);
        double y2 = -this.arcRadius * Math.sin(Math.toRadians(angle + arrowLength)) * (1.0 - t1 * ta);
        double x3 = x2 + 2.0 * this.arcRadius * t1 * ta * Math.cos(Math.toRadians(60.0 - angle - arrowLength));
        double y3 = y2 + 2.0 * this.arcRadius * t1 * ta * Math.sin(Math.toRadians(60.0 - angle - arrowLength));
        double x4 = this.arcRadius * Math.cos(Math.toRadians(angle + arrowLength)) * (1.0 + t1 * ta);
        double y4 = -this.arcRadius * Math.sin(Math.toRadians(angle + arrowLength)) * (1.0 + t1 * ta);
        double x5 = (this.arcRadius + wA / 2.0) * Math.cos(Math.toRadians(angle + arrowLength));
        double y5 = -(this.arcRadius + wA / 2.0) * Math.sin(Math.toRadians(angle + arrowLength));
        double x6 = (this.arcRadius + wA / 2.0) * Math.cos(Math.toRadians(this.arcAngle));
        double y6 = -(this.arcRadius + wA / 2.0) * Math.sin(Math.toRadians(this.arcAngle));
        ArcTo arcToInner = new ArcTo();
        arcToInner.setX(x1);
        arcToInner.setY(y1);
        arcToInner.setRadiusX(this.arcRadius - wA / 2.0);
        arcToInner.setRadiusY(this.arcRadius - wA / 2.0);
        arcToInner.setSweepFlag(true);
        arcToInner.setLargeArcFlag(length > 180.0 + arrowLength);
        ArcTo arcToOuter = new ArcTo();
        arcToOuter.setX(x6);
        arcToOuter.setY(y6);
        arcToOuter.setRadiusX(this.arcRadius + wA / 2.0);
        arcToOuter.setRadiusY(this.arcRadius + wA / 2.0);
        arcToOuter.setSweepFlag(false);
        arcToOuter.setLargeArcFlag(length > 180.0 + arrowLength);
        if (length < 115.0) {
            this.path.getElements().setAll((Object[])new PathElement[]{new MoveTo(x0, y0), arcToInner, new LineTo(x5, y5), arcToOuter, new ClosePath()});
        } else {
            this.path.getElements().setAll((Object[])new PathElement[]{new MoveTo(x0, y0), arcToInner, new LineTo(x2, y2), new LineTo(x3, y3), new LineTo(x4, y4), new LineTo(x5, y5), arcToOuter, new ClosePath()});
        }
    }

    private void applyPullingMode() {
        this.path.setManaged(true);
        this.path.setVisible(true);
        this.gCircle.setManaged(true);
        this.gCircle.setVisible(true);
        this.progressIndicator.setManaged(false);
        this.progressIndicator.setVisible(false);
    }

    private void applyRefreshingMode() {
        this.path.setManaged(false);
        this.path.setVisible(false);
        this.gCircle.setManaged(false);
        this.gCircle.setVisible(false);
        this.progressIndicator.setManaged(true);
        this.progressIndicator.setVisible(true);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return RefreshIndicatorSkin.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<RefreshIndicator, Paint>> styleables = new ArrayList<CssMetaData<RefreshIndicator, Paint>>(Control.getClassCssMetaData());
        styleables.add(COLOR);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

