/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.control.skin.settings;

import com.gluonhq.charm.glisten.control.settings.Option;
import com.gluonhq.charm.glisten.control.settings.OptionEditor;
import com.gluonhq.charm.glisten.control.settings.OptionEditorBase;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.ToggleButton;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;

public class DefaultOptionEditorFactory<T>
implements Callback<Option<T>, OptionEditor<T>> {
    private static final Class<?>[] numericTypes = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigInteger.class, BigDecimal.class};

    public OptionEditor<T> call(Option<T> option) {
        if (option.valueProperty().getValue() == null) {
            return null;
        }
        Class<?> type = option.valueProperty().getValue().getClass();
        if (option.editorFactoryProperty().isPresent()) {
            return option.editorFactoryProperty().get().apply(option);
        }
        if (type == String.class) {
            return DefaultOptionEditorFactory.createTextEditor(option);
        }
        if (DefaultOptionEditorFactory.isNumber(type)) {
            return DefaultOptionEditorFactory.createNumberEditor(option);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return DefaultOptionEditorFactory.createSwitchEditor(option);
        }
        if (type == LocalDate.class) {
            return DefaultOptionEditorFactory.createDateEditor(option);
        }
        if (type == Color.class || type == Paint.class) {
            return DefaultOptionEditorFactory.createColorEditor(option);
        }
        if (type != null && type.isEnum()) {
            return DefaultOptionEditorFactory.createComboBoxEditor(option, Arrays.asList(type.getEnumConstants()));
        }
        System.err.println("type " + type + ": No editor found for " + option.getCaption());
        return null;
    }

    public static final OptionEditor<String> createTextEditor(Option option) {
        return new OptionEditorBase<String, TextField>(option, new TextField()){
            {
                DefaultOptionEditorFactory.enableAutoSelectAll((TextInputControl)this.getEditor());
            }

            public StringProperty valueProperty() {
                return ((TextField)this.getEditor()).textProperty();
            }

            @Override
            public void setValue(String value) {
                ((TextField)this.getEditor()).setText(value);
            }
        };
    }

    public static final OptionEditor<Number> createNumberEditor(final Option<Number> option) {
        return new OptionEditorBase<Number, TextField>(option, new TextField()){
            private ObjectProperty<Number> innerValueProperty;
            private Class<? extends Number> cls;
            private DecimalFormat format;
            private boolean editing;
            {
                super(option3, control);
                this.cls = ((Number)option.valueProperty().getValue()).getClass();
                this.editing = false;
                DefaultOptionEditorFactory.enableAutoSelectAll((TextInputControl)this.getEditor());
                NumberFormat nf = NumberFormat.getNumberInstance();
                this.format = (DecimalFormat)nf;
                if (this.cls == Byte.TYPE || this.cls == Byte.class || this.cls == Short.TYPE || this.cls == Short.class || this.cls == Integer.TYPE || this.cls == Integer.class || this.cls == Long.TYPE || this.cls == Long.class || this.cls == BigInteger.class) {
                    this.format.setParseIntegerOnly(true);
                    this.format.setMaximumFractionDigits(0);
                    this.format.setGroupingUsed(false);
                    this.format.setDecimalSeparatorAlwaysShown(false);
                    ((TextField)this.getEditor()).setTextFormatter(new TextFormatter(c -> {
                        if (c.getControlNewText().isEmpty()) {
                            return c;
                        }
                        ParsePosition parsePosition = new ParsePosition(0);
                        Number num = this.format.parse(c.getControlNewText(), parsePosition);
                        if (num == null || parsePosition.getIndex() < c.getControlNewText().length()) {
                            return null;
                        }
                        this.editing = true;
                        if (this.cls == Long.TYPE || this.cls == Long.class) {
                            this.innerValueProperty.setValue((Object)num.longValue());
                        } else {
                            this.innerValueProperty.setValue((Object)num.intValue());
                        }
                        this.editing = false;
                        return c;
                    }));
                } else {
                    this.format.setGroupingUsed(false);
                    ((TextField)this.getEditor()).setTextFormatter(new TextFormatter(c -> {
                        if (c.getControlNewText().isEmpty()) {
                            return c;
                        }
                        ParsePosition parsePosition = new ParsePosition(0);
                        Number num = this.format.parse(c.getControlNewText().toUpperCase(Locale.ROOT), parsePosition);
                        if (num == null || parsePosition.getIndex() < c.getControlNewText().length()) {
                            return null;
                        }
                        this.editing = true;
                        this.innerValueProperty.setValue((Object)num.doubleValue());
                        this.editing = false;
                        return c;
                    }));
                }
            }

            @Override
            public ObjectProperty<Number> valueProperty() {
                if (this.innerValueProperty == null) {
                    this.innerValueProperty = new SimpleObjectProperty();
                    this.innerValueProperty.addListener((obs, ov, nv) -> {
                        if (nv != null && this.format != null && !this.editing) {
                            this.setValue((Number)nv);
                        }
                    });
                }
                return this.innerValueProperty;
            }

            @Override
            public void setValue(Number value) {
                ((TextField)this.getEditor()).setText(this.format.format(value));
            }

            @Override
            public Number getValue() {
                return (Number)this.innerValueProperty.get();
            }
        };
    }

    public static final OptionEditor<Boolean> createSwitchEditor(Option option) {
        return new OptionEditorBase<Boolean, ToggleButton>(option, new ToggleButton()){
            {
                ((ToggleButton)this.getEditor()).getStyleClass().add((Object)"switch");
            }

            public BooleanProperty valueProperty() {
                return ((ToggleButton)this.getEditor()).selectedProperty();
            }

            @Override
            public void setValue(Boolean value) {
                ((ToggleButton)this.getEditor()).setSelected(value.booleanValue());
            }
        };
    }

    public static final <T> OptionEditor<T> createComboBoxEditor(Option<T> option, final Collection<T> items) {
        return new OptionEditorBase<T, ComboBox<T>>(option, new ComboBox()){
            private ObjectProperty<T> selectedItemProperty;
            {
                super(option, control);
                ((ComboBox)this.getEditor()).setItems(FXCollections.observableArrayList((Collection)items));
                ((ComboBox)this.getEditor()).setEditable(false);
            }

            @Override
            public ObjectProperty<T> valueProperty() {
                if (this.selectedItemProperty == null) {
                    this.selectedItemProperty = new SimpleObjectProperty();
                    ((ComboBox)this.getEditor()).getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> this.selectedItemProperty.set(nv));
                    this.selectedItemProperty.addListener((obs, ov, nv) -> this.setValue(nv));
                }
                return this.selectedItemProperty;
            }

            @Override
            public void setValue(T value) {
                ((ComboBox)this.getEditor()).getSelectionModel().select(value);
            }
        };
    }

    public static final OptionEditor<Color> createColorEditor(Option option) {
        return new OptionEditorBase<Color, ColorPicker>(option, new ColorPicker()){

            @Override
            public ObjectProperty<Color> valueProperty() {
                return ((ColorPicker)this.getEditor()).valueProperty();
            }

            @Override
            public void setValue(Color value) {
                ((ColorPicker)this.getEditor()).setValue((Object)value);
            }
        };
    }

    public static final OptionEditor<LocalDate> createDateEditor(Option option) {
        return new OptionEditorBase<LocalDate, DatePicker>(option, new DatePicker()){

            @Override
            public ObjectProperty<LocalDate> valueProperty() {
                return ((DatePicker)this.getEditor()).valueProperty();
            }

            @Override
            public void setValue(LocalDate value) {
                ((DatePicker)this.getEditor()).setValue((Object)value);
            }
        };
    }

    private static void enableAutoSelectAll(TextInputControl control) {
        control.focusedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                Platform.runLater(() -> control.selectAll());
            }
        });
    }

    private static boolean isNumber(Class<?> type) {
        if (type == null) {
            return false;
        }
        for (Class<?> cls : numericTypes) {
            if (type != cls) continue;
            return true;
        }
        return false;
    }
}

