/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.control.skin.util;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class CircularRippleEffect {
    private static final Color rippleColor = new Color(0.0, 0.0, 0.0, 0.11);
    private static final Duration rippleDuration = Duration.millis((double)250.0);
    private final Circle ripple = new Circle(0.1, (Paint)rippleColor);
    private final Timeline scaleRippleTimeline = new Timeline();
    private final SequentialTransition parallelTransition = new SequentialTransition();
    private Rectangle rippleClip = new Rectangle();
    private double lastRippleHeight = 0.0;
    private double lastRippleWidth = 0.0;
    private Region skinnable;

    public static void apply(SkinBase<?> skin) {
        new CircularRippleEffect(skin);
    }

    private CircularRippleEffect(SkinBase<?> skin) {
        this.skinnable = skin.getSkinnable();
        this.skinnable.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.execute(event.getX(), event.getY()));
        skin.getChildren().add(0, (Object)this.ripple);
        this.ripple.setOpacity(0.0);
        this.ripple.setEffect((Effect)new BoxBlur(3.0, 3.0, 2));
        FadeTransition fadeTransition = new FadeTransition(rippleDuration, (Node)this.ripple);
        fadeTransition.setInterpolator(Interpolator.EASE_OUT);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue(0.0);
        this.parallelTransition.getChildren().addAll((Object[])new Animation[]{this.scaleRippleTimeline, fadeTransition});
        this.parallelTransition.setOnFinished(event -> {
            this.ripple.setOpacity(0.0);
            this.ripple.setRadius(0.1);
        });
    }

    private void execute(double x, double y) {
        this.parallelTransition.stop();
        this.parallelTransition.getOnFinished().handle(null);
        this.ripple.setCenterX(x);
        this.ripple.setCenterY(y);
        double width = this.skinnable.getWidth();
        double height = this.skinnable.getHeight();
        if (width != this.lastRippleWidth || height != this.lastRippleHeight) {
            this.lastRippleWidth = width;
            this.lastRippleHeight = height;
            this.rippleClip.setWidth(this.lastRippleWidth);
            this.rippleClip.setHeight(this.lastRippleHeight);
            try {
                CornerRadii radii = ((BackgroundFill)this.skinnable.getBackground().getFills().get(0)).getRadii();
                this.rippleClip.setArcHeight(radii.getTopLeftHorizontalRadius());
                this.rippleClip.setArcWidth(radii.getTopLeftHorizontalRadius());
                this.ripple.setClip((Node)this.rippleClip);
            }
            catch (Exception radii) {
                // empty catch block
            }
            double circleRippleRadius = Math.max(height, width) * 0.45;
            KeyValue keyValue = new KeyValue((WritableValue)this.ripple.radiusProperty(), (Object)circleRippleRadius, Interpolator.EASE_OUT);
            KeyFrame keyFrame = new KeyFrame(rippleDuration, new KeyValue[]{keyValue});
            this.scaleRippleTimeline.getKeyFrames().clear();
            this.scaleRippleTimeline.getKeyFrames().add((Object)keyFrame);
        }
        this.parallelTransition.playFromStart();
    }
}

