/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.control.skin.util;

import com.gluonhq.impl.charm.glisten.control.skin.util.SourceListChange;
import java.util.BitSet;
import java.util.TreeSet;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.transformation.SortedList;
import javafx.collections.transformation.TransformationList;

public class HeadersList<E, K extends Comparable>
extends TransformationList<E, E> {
    private int size;
    private Element<E>[] sorted;
    private ElementFunction<E, K> elementFunction;
    private BitSet headersIndex = new BitSet();
    private ObjectProperty<Function<? super E, K>> function;

    public HeadersList(SortedList<? extends E> source) {
        this(source, null);
    }

    public HeadersList(SortedList<? extends E> source, Function<? super E, K> function) {
        super(source);
        this.sorted = new Element[source.size() * 2 + 1];
        this.size = source.size();
        for (int i = 0; i < this.size; ++i) {
            this.sorted[i] = new Element<Object>(source.get(i), i);
        }
        this.headersIndex = new BitSet(this.size);
        if (function != null) {
            this.setFunction(function);
        }
    }

    public final ObjectProperty<Function<? super E, K>> functionProperty() {
        if (this.function == null) {
            this.function = new ObjectPropertyBase<Function<? super E, K>>(){

                protected void invalidated() {
                    Function current = (Function)this.get();
                    HeadersList.this.elementFunction = current != null ? new ElementFunction(current) : null;
                    HeadersList.this.findHeaders();
                }

                public Object getBean() {
                    return HeadersList.this;
                }

                public String getName() {
                    return "function";
                }
            };
        }
        return this.function;
    }

    public final Function<? super E, K> getFunction() {
        return this.function == null ? null : (Function)this.function.get();
    }

    public final void setFunction(Function<? super E, K> function) {
        this.functionProperty().set(function);
    }

    protected void sourceChanged(ListChangeListener.Change<? extends E> c) {
        this.beginChange();
        while (c.next()) {
            if (!c.wasAdded() && !c.wasRemoved()) continue;
            this.size = this.getSource().size();
            this.sorted = new Element[this.size * 2 + 1];
            for (int i = 0; i < this.size; ++i) {
                this.sorted[i] = new Element<Object>(this.getSource().get(i), i);
            }
            this.findHeaders();
        }
        this.endChange();
        this.fireChange(new SourceListChange<E>(this, c));
    }

    public int getSourceIndex(int index) {
        return index;
    }

    public int getViewIndex(int index) {
        return index;
    }

    public E get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.sorted[index].e;
    }

    public int size() {
        return this.size;
    }

    public BitSet getHeadersIndex() {
        return this.headersIndex;
    }

    private void ensureSize(int size) {
        if (this.sorted.length < size) {
            Element[] replacement = new Element[size * 2 + 1];
            System.arraycopy(this.sorted, 0, replacement, 0, this.size);
            this.sorted = replacement;
        }
    }

    private void updateIndices(int from, int difference) {
        for (int i = 0; i < this.size; ++i) {
            if (this.sorted[i].index < from) continue;
            this.sorted[i].index += difference;
        }
    }

    private void findHeaders() {
        if (this.elementFunction == null) {
            return;
        }
        TreeSet<Comparable> headerSet = new TreeSet<Comparable>();
        for (Element<E> elem : this.sorted) {
            Comparable k = (Comparable)this.elementFunction.apply(elem);
            if (k == null) continue;
            headerSet.add(k);
        }
        while (headerSet.size() > 0) {
            Comparable header = (Comparable)headerSet.last();
            for (Element<E> elem : this.sorted) {
                if (elem == null || this.elementFunction.apply(elem) == null || !((Comparable)this.elementFunction.apply(elem)).equals(header)) continue;
                this.ensureSize(this.size + 1);
                this.updateIndices(elem.index, 1);
                System.arraycopy(this.sorted, elem.index, this.sorted, elem.index + 1, this.size - elem.index);
                ++this.size;
                this.sorted[elem.index] = new Element(elem.e, elem.index);
                --this.sorted[elem.index - 1].index;
                break;
            }
            headerSet.remove(header);
        }
        this.headersIndex = new BitSet(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.headersIndex.set(i, this.sorted[i + 1] != null && this.sorted[i].e.equals(this.sorted[i + 1].e));
        }
    }

    private static class ElementFunction<E, K>
    implements Function<Element<E>, K> {
        private final Function<? super E, K> function;

        public ElementFunction(Function<? super E, K> function) {
            this.function = function;
        }

        @Override
        public K apply(Element<E> elem) {
            if (this.function == null || elem == null || elem.e == null) {
                return null;
            }
            return this.function.apply(elem.e);
        }
    }

    private static class Element<E> {
        private E e;
        private int index;

        public Element(E e, int index) {
            this.e = e;
            this.index = index;
        }
    }
}

