/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.control.skin.util;

import com.gluonhq.charm.glisten.layout.layer.PopupView;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;

public class PopupPlacementUtils {
    public static Point2D calculatePopupPosition(Node ownerNode, Node popupRoot, Insets popupPadding, PopupView.PopupSide popupSide, double yOffset) {
        double y;
        Scene scene = ownerNode.getScene();
        double sceneWidth = scene.getWidth();
        double sceneHeight = scene.getHeight();
        Bounds b = ownerNode.getLocalToSceneTransform().transform(ownerNode.getLayoutBounds());
        double topPadding = popupPadding.getTop();
        double rightPadding = popupPadding.getRight();
        double leftPadding = popupPadding.getLeft();
        double popupWidth = popupRoot.prefWidth(-1.0);
        double popupHeight = popupRoot.prefHeight(popupWidth);
        double x = Math.max(b.getMinX(), leftPadding);
        if (popupSide == PopupView.PopupSide.RIGHT) {
            x = Math.min(b.getMaxX(), sceneWidth - rightPadding) - popupWidth;
            double d = x = x > leftPadding ? x : leftPadding;
        }
        if ((y = Math.max(b.getMinY() + yOffset, topPadding)) + popupHeight > sceneHeight && b.getMaxY() > sceneHeight - b.getMinY()) {
            y = b.getMaxY() - yOffset - popupHeight - popupPadding.getBottom();
        }
        return new Point2D(x, y);
    }
}

