/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.control.skin.util;

import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class SourceListChange<T>
extends ListChangeListener.Change<T> {
    private final ListChangeListener.Change<? extends T> change;
    private int[] permutation;

    public SourceListChange(ObservableList<T> list, ListChangeListener.Change<? extends T> change) {
        super(list);
        this.change = change;
    }

    public boolean next() {
        this.permutation = null;
        return this.change.next();
    }

    public void reset() {
        this.change.reset();
    }

    public int getTo() {
        return this.change.getTo();
    }

    public List<T> getRemoved() {
        return this.change.getRemoved();
    }

    public int getFrom() {
        return this.change.getFrom();
    }

    public boolean wasUpdated() {
        return this.change.wasUpdated();
    }

    protected int[] getPermutation() {
        if (this.permutation == null) {
            if (this.change.wasPermutated()) {
                int from = this.getFrom();
                int diff = this.getTo() - from;
                this.permutation = new int[diff];
                for (int index = 0; index < diff; ++index) {
                    this.permutation[index] = this.change.getPermutation(from + index);
                }
            } else {
                this.permutation = new int[0];
            }
        }
        return this.permutation;
    }

    public String toString() {
        return this.change.toString();
    }
}

