/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.license;

import com.gluonhq.attach.storage.StorageService;
import com.gluonhq.charm.glisten.license.License;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;

public class LicenseManager {
    private static final Logger LOGGER = Logger.getLogger(LicenseManager.class.getName());
    private static File storageDir;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String validateLicense(String charmVersion, License license, Runnable runIfInvalid) {
        File licenseFile;
        String licenseKey = null;
        if (license != null) {
            licenseKey = license.key();
        } else {
            try (InputStream is = LicenseManager.class.getClassLoader().getResourceAsStream("gluonmobile.license");){
                if (is == null) {
                    LOGGER.log(Level.FINEST, "no license annotation or file gluonmobile.license");
                    String s22 = null;
                    return s22;
                }
                Scanner s22 = new Scanner(is);
                licenseKey = s22.hasNext() ? s22.next() : "";
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "error reading license file gluonmobile.license", ex);
            }
        }
        if (storageDir != null && (licenseFile = new File(storageDir, "license.file")).exists()) {
            String fileContent = null;
            try (BufferedReader br = new BufferedReader(new FileReader(licenseFile));){
                fileContent = br.readLine();
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            if (fileContent != null) {
                if (fileContent.equals(LicenseManager.generateHash(licenseKey))) {
                    LOGGER.log(Level.INFO, "Validation of license key " + licenseKey + " completed, Valid license.file exists.");
                    return licenseKey;
                }
                LOGGER.log(Level.WARNING, "license.file invalid - continue validation");
            }
        }
        LicenseManager.checkLicense(charmVersion, licenseKey, runIfInvalid);
        return licenseKey;
    }

    private static void checkLicense(final String charmVersion, final String licenseKey, final Runnable runIfInvalid) {
        new Thread(){

            @Override
            public void run() {
                block15: {
                    try {
                        URI uri = new URI("http", null, "license.gluonhq.com", -1, "/cl/license/validate", "type=charm&version=" + charmVersion + "&licenseKey=" + licenseKey, null);
                        URL url = uri.toURL();
                        try (InputStream s = url.openStream();){
                            String l;
                            BufferedReader br = new BufferedReader(new InputStreamReader(s));
                            StringBuilder b = new StringBuilder();
                            while ((l = br.readLine()) != null) {
                                b.append(l);
                            }
                            if (b.toString().indexOf("false") > 0) {
                                LOGGER.log(Level.WARNING, "Validation of license key " + licenseKey + " completed. License INVALID");
                                Platform.runLater((Runnable)runIfInvalid);
                                break block15;
                            }
                            if (b.toString().indexOf("true") <= 0) break block15;
                            LOGGER.log(Level.INFO, "Validation of license key " + licenseKey + " completed. License VALID");
                            if (storageDir == null) break block15;
                            File licenseFile = new File(storageDir, "license.file");
                            try (BufferedWriter w = new BufferedWriter(new FileWriter(licenseFile));){
                                w.write(LicenseManager.generateHash(licenseKey));
                            }
                        }
                    }
                    catch (Throwable ex) {
                        LOGGER.log(Level.SEVERE, "problem checking license url", ex);
                    }
                }
            }
        }.start();
    }

    public static String generateHash(String input) {
        try {
            input = "C!@rm" + input + "Licen$e";
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(input.getBytes("UTF-8"));
            byte[] hash = md.digest();
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append("0");
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            return "";
        }
    }

    static {
        try {
            storageDir = (File)StorageService.create().flatMap(StorageService::getPrivateStorage).orElseThrow(() -> new IOException("Private storage file not available"));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

