/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.tracking;

import com.gluonhq.attach.storage.StorageService;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TrackingManager {
    private static final Logger LOGGER = Logger.getLogger(TrackingManager.class.getName());
    private static File storageDir;

    public static boolean trackUsage(String charmVersion, String license) {
        block9: {
            if (license == null) {
                license = "NOLICENSE";
            }
            if (storageDir != null) {
                try {
                    File logFile = new File(storageDir, "gluonmobile.log");
                    if (logFile.exists()) break block9;
                    TrackingManager.sendLog(charmVersion, license);
                    try (BufferedWriter w = new BufferedWriter(new FileWriter(logFile));){
                        w.write("OK");
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private static void sendLog(final String charmVersion, final String id) {
        new Thread(){

            @Override
            public void run() {
                try {
                    String java = System.getProperty("java.version");
                    String os = System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version");
                    String urlParameters = "os=" + URLEncoder.encode(os, "UTF-8") + "&java=" + URLEncoder.encode(java, "UTF-8") + "&type=mobile&id=" + URLEncoder.encode(id, "UTF-8") + "&version=" + charmVersion;
                    URL url = new URL("https://cloud.gluonhq.com/3/tracking/ul/log?" + urlParameters);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(10000);
                    conn.setRequestMethod("GET");
                    conn.setUseCaches(false);
                    conn.connect();
                    try (DataInputStream in = new DataInputStream(conn.getInputStream());){
                        while (in.read() > -1) {
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }.start();
    }

    static {
        try {
            storageDir = (File)StorageService.create().flatMap(StorageService::getPrivateStorage).orElseThrow(() -> new IOException("Private storage file not available"));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

