/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.util;

import com.gluonhq.attach.display.DisplayService;
import com.gluonhq.attach.lifecycle.LifecycleEvent;
import com.gluonhq.attach.lifecycle.LifecycleService;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.control.Control;

public class DeviceSettings {
    private static final PseudoClass LANDSCAPE = PseudoClass.getPseudoClass((String)"horizontal");
    private static final PseudoClass LEFT = PseudoClass.getPseudoClass((String)"left");
    private static boolean notch;
    private static boolean inited;

    public static boolean hasNotch() {
        if (!inited) {
            notch = DisplayService.create().map(DisplayService::hasNotch).orElse(false);
            inited = true;
        }
        return notch;
    }

    public static void dedicatedSetup(Control control) {
        if (Platform.isFxApplicationThread()) {
            DeviceSettings.setup(control);
        } else {
            Platform.runLater(() -> DeviceSettings.setup(control));
        }
    }

    private static void setup(Control control) {
        if (!DeviceSettings.hasNotch()) {
            return;
        }
        DisplayService.create().ifPresent(service -> {
            ChangeListener notchListener = (obs, ov, nv) -> DeviceSettings.applyPseudoClass(control, ov, nv);
            LifecycleService.create().ifPresent(l -> {
                l.addListener(LifecycleEvent.RESUME, () -> service.notchProperty().addListener(notchListener));
                l.addListener(LifecycleEvent.PAUSE, () -> service.notchProperty().removeListener(notchListener));
            });
            service.notchProperty().addListener(notchListener);
            DeviceSettings.applyPseudoClass(control, null, (DisplayService.Notch)((Object)((Object)service.notchProperty().get())));
        });
    }

    private static void applyPseudoClass(Control control, DisplayService.Notch oldNotch, DisplayService.Notch notch) {
        if (notch == DisplayService.Notch.BOTTOM && oldNotch != null || notch == DisplayService.Notch.UNKNOWN && (oldNotch == DisplayService.Notch.LEFT || oldNotch == DisplayService.Notch.RIGHT)) {
            control.pseudoClassStateChanged(LANDSCAPE, oldNotch == DisplayService.Notch.LEFT || oldNotch == DisplayService.Notch.RIGHT);
            control.pseudoClassStateChanged(LEFT, oldNotch == DisplayService.Notch.LEFT);
        } else {
            control.pseudoClassStateChanged(LANDSCAPE, notch == DisplayService.Notch.LEFT || notch == DisplayService.Notch.RIGHT);
            control.pseudoClassStateChanged(LEFT, notch == DisplayService.Notch.LEFT);
        }
    }
}

