/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.glisten.util;

import com.gluonhq.charm.glisten.control.Avatar;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.Scene;

public class StylesheetTools {
    private static final Class<?> BASE_CLASS = Avatar.class;
    private static final String RESOURCE_ABBR = "css";

    private StylesheetTools() {
    }

    public static String buildResourceName(String stylesheetPrefix, String newStylesheetName) {
        return stylesheetPrefix + newStylesheetName.toLowerCase(Locale.ROOT) + "." + RESOURCE_ABBR;
    }

    public static void replaceStylesheet(Scene scene, String stylesheetPrefix, String newStylesheetName) {
        Objects.requireNonNull(scene, "Scene cannot be null");
        Objects.requireNonNull(stylesheetPrefix, "Stylesheet prefix cannot be null");
        Objects.requireNonNull(scene, "New stylesheet name cannot be null");
        String resourceName = StylesheetTools.buildResourceName(stylesheetPrefix, newStylesheetName);
        ObservableList sceneStylesheets = scene.getStylesheets();
        ArrayList<String> invalidStylesheets = new ArrayList<String>();
        for (String s : sceneStylesheets) {
            if (!s.contains(stylesheetPrefix)) continue;
            invalidStylesheets.add(s);
        }
        sceneStylesheets.removeAll(invalidStylesheets);
        sceneStylesheets.add((Object)StylesheetTools.asResource(resourceName));
    }

    public static void addStylesheet(Scene scene, String stylesheetName) {
        Objects.requireNonNull(scene, "No scene found");
        scene.getStylesheets().add((Object)StylesheetTools.asResource(stylesheetName));
    }

    public static String asResource(String stylesheetName) {
        return BASE_CLASS.getResource(stylesheetName).toExternalForm();
    }

    public static InputStream asResourceStream(String stylesheetName) {
        return BASE_CLASS.getResourceAsStream(stylesheetName);
    }
}

