/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.scenebuilder.plugins;

import com.gluonhq.scenebuilder.plugins.alert.ImportingGluonControlsAlert;
import com.gluonhq.scenebuilder.plugins.alert.WarnThemeAlert;
import com.gluonhq.scenebuilder.plugins.editor.GluonEditorController;
import com.gluonhq.scenebuilder.plugins.editor.GluonEditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.ExternalThemeProvider;
import java.util.List;
import java.util.function.Consumer;
import javafx.stage.Stage;

public class GluonExternalThemeProvider
implements ExternalThemeProvider {
    @Override
    public List<EditorPlatform.Theme> getExternalThemes() {
        return List.of(GluonEditorPlatform.GLUON_MOBILE, GluonEditorPlatform.GLUON_MOBILE_LIGHT, GluonEditorPlatform.GLUON_MOBILE_DARK);
    }

    @Override
    public List<String> getExternalStylesheets() {
        String modenaStylesheet = EditorPlatform.Theme.MODENA.getStylesheetURLs().getFirst();
        String gluonStylesheet = GluonEditorPlatform.GLUON_MOBILE.getStylesheetURLs().getFirst();
        String gluonThemeStylesheet = GluonEditorController.getInstance().getGluonTheme().getStylesheetURLs().getFirst();
        String gluonSwatchStylesheet = GluonEditorController.getInstance().getGluonSwatch().getStylesheetURLs().getFirst();
        String gluonDocumentStylesheet = GluonExternalThemeProvider.getGluonDocumentStylesheetURL();
        return List.of(modenaStylesheet, gluonStylesheet, gluonThemeStylesheet, gluonSwatchStylesheet, gluonDocumentStylesheet);
    }

    @Override
    public boolean hasClassFromExternalPlugin(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        if (text.startsWith("com.gluonhq.charm.glisten") || text.contains("com.gluonhq.charm.glisten")) {
            return true;
        }
        return text.startsWith("com.gluonhq.impl.charm.glisten") || text.contains("com.gluonhq.impl.charm.glisten");
    }

    @Override
    public void showThemeAlert(Stage owner, EditorPlatform.Theme currentTheme, Consumer<EditorPlatform.Theme> onSuccess) {
        WarnThemeAlert.showAlertIfRequired(owner, currentTheme, onSuccess);
    }

    @Override
    public void showImportAlert(Stage owner) {
        new ImportingGluonControlsAlert(owner).showAndWait();
    }

    @Override
    public String getExternalJavadocURL() {
        return "https://docs.gluonhq.com/charm/javadoc/latest/";
    }

    public static String getGluonDocumentStylesheetURL() {
        return "com/gluonhq/scenebuilder/plugins/css/GluonDocument.css";
    }
}

