/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.scenebuilder.plugins.alert;

import com.gluonhq.scenebuilder.plugins.editor.GluonEditorPlatform;
import com.gluonhq.scenebuilder.plugins.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.alert.SBAlert;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import java.util.function.Consumer;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;

public class WarnThemeAlert
extends SBAlert {
    private static boolean hasBeenShown = false;

    private WarnThemeAlert(Stage owner, Consumer<EditorPlatform.Theme> onSuccess) {
        super(Alert.AlertType.WARNING, owner);
        this.setTitle(I18N.getString("alert.theme.gluon.mobile.title"));
        this.setHeaderText(I18N.getString("alert.theme.gluon.mobile.headertext"));
        this.setContentText(I18N.getString("alert.theme.gluon.mobile.contenttext"));
        ButtonType setGluonTheme = new ButtonType(I18N.getString("alert.theme.gluon.mobile.setgluontheme"), ButtonBar.ButtonData.OK_DONE);
        ButtonType ignore = new ButtonType(I18N.getString("alert.theme.gluon.mobile.ignore"), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getButtonTypes().setAll((Object[])new ButtonType[]{setGluonTheme, ignore});
        this.resultProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == setGluonTheme && onSuccess != null) {
                onSuccess.accept(GluonEditorPlatform.GLUON_MOBILE_LIGHT);
            }
        });
        this.setOnShown(event -> {
            hasBeenShown = true;
        });
    }

    public static void showAlertIfRequired(Stage owner, EditorPlatform.Theme currentTheme, Consumer<EditorPlatform.Theme> onSuccess) {
        if (!(hasBeenShown || GluonEditorPlatform.isGluonMobileLight(currentTheme) || GluonEditorPlatform.isGluonMobileDark(currentTheme))) {
            new WarnThemeAlert(owner, onSuccess).showAndWait();
        }
    }
}

