/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.scenebuilder.plugins.hierarchy;

import com.oracle.javafx.scenebuilder.kit.editor.images.ImageUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.hierarchy.HierarchyItem;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import javafx.scene.image.Image;

public class HierarchyItemExpandedPanel
extends HierarchyItem {
    private final DesignHierarchyMask.Accessory accessory;
    private final DesignHierarchyMask owner;

    public HierarchyItemExpandedPanel(DesignHierarchyMask owner, FXOMObject fxomObject, DesignHierarchyMask.Accessory accessory) {
        assert (owner != null);
        this.owner = owner;
        this.mask = fxomObject == null ? null : new DesignHierarchyMask(fxomObject);
        this.accessory = accessory;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchyItemExpandedPanel item = (HierarchyItemExpandedPanel)obj;
        if (!this.isEmpty()) {
            assert (this.getFxomObject() != null);
            return this.getFxomObject().equals(item.getFxomObject());
        }
        return this.getOwner().equals(item.getOwner()) && this.getAccessory().equals(item.getAccessory());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.mask);
        hash = 37 * hash + Objects.hashCode(this.owner);
        hash = 37 * hash + Objects.hashCode(this.accessory);
        return hash;
    }

    @Override
    public boolean isPlaceholder() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.mask == null;
    }

    public DesignHierarchyMask getOwner() {
        return this.owner;
    }

    public DesignHierarchyMask.Accessory getAccessory() {
        return this.accessory;
    }

    @Override
    public Image getPlaceholderImage() {
        return ImageUtils.getNodeIcon("CustomNode.png");
    }

    @Override
    public String getPlaceholderInfo() {
        return this.mask != null ? null : I18N.getString("hierarchy.placeholder.insert", this.accessory.toString().toUpperCase(Locale.ROOT));
    }

    @Override
    public Image getClassNameIcon() {
        return this.mask == null ? null : this.mask.getClassNameIcon();
    }

    @Override
    public URL getClassNameIconURL() {
        return this.mask == null ? null : this.mask.getClassNameIconURL();
    }

    @Override
    public String getClassNameInfo() {
        return this.mask == null ? null : this.mask.getClassNameInfo();
    }
}

