/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.app;

import com.oracle.javafx.scenebuilder.app.util.MessageBox;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;

public class AppPlatform {
    private static String applicationDataFolder;
    private static String userLibraryFolder;
    private static String messageBoxFolder;
    private static String logsFolder;
    private static MessageBox<MessageBoxMessage> messageBox;

    AppPlatform() {
    }

    public static synchronized String getApplicationDataFolder() {
        if (applicationDataFolder == null) {
            String appName = "Scene Builder";
            if (EditorPlatform.IS_WINDOWS) {
                applicationDataFolder = System.getenv("APPDATA") + "\\Scene Builder";
            } else if (EditorPlatform.IS_MAC) {
                applicationDataFolder = System.getProperty("user.home") + "/Library/Application Support/Scene Builder";
            } else if (EditorPlatform.IS_LINUX) {
                applicationDataFolder = System.getProperty("user.home") + "/.scenebuilder";
            }
        }
        assert (applicationDataFolder != null);
        return applicationDataFolder;
    }

    public static synchronized String getUserLibraryFolder() {
        if (userLibraryFolder == null) {
            userLibraryFolder = AppPlatform.getApplicationDataFolder() + "/Library";
        }
        return userLibraryFolder;
    }

    public static synchronized String getLogFolder() {
        if (logsFolder == null) {
            logsFolder = Paths.get(System.getProperty("user.home"), ".scenebuilder", "logs").toString();
        }
        return logsFolder;
    }

    public static boolean requestStart(AppNotificationHandler notificationHandler, Application.Parameters parameters) throws IOException {
        if (EditorPlatform.isAssertionEnabled()) {
            notificationHandler.handleLaunch(parameters.getUnnamed());
            return true;
        }
        return AppPlatform.requestStartGeneric(notificationHandler, parameters);
    }

    private static synchronized boolean requestStartGeneric(AppNotificationHandler notificationHandler, Application.Parameters parameters) throws IOException {
        boolean result;
        assert (notificationHandler != null);
        assert (parameters != null);
        assert (messageBox == null);
        try {
            Files.createDirectories(Paths.get(AppPlatform.getMessageBoxFolder(), new String[0]), new FileAttribute[0]);
            Files.createDirectories(Paths.get(AppPlatform.getLogFolder(), new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        messageBox = new MessageBox<MessageBoxMessage>(AppPlatform.getMessageBoxFolder(), MessageBoxMessage.class, 1000);
        ArrayList<String> parametersUnnamed = new ArrayList<String>(parameters.getUnnamed());
        if (EditorPlatform.IS_MAC) {
            parametersUnnamed.removeIf(p -> p.startsWith("-psn"));
        }
        if (messageBox.grab(new MessageBoxDelegate(notificationHandler))) {
            notificationHandler.handleLaunch(parametersUnnamed);
            result = true;
        } else {
            result = false;
            MessageBoxMessage unamedParameters = new MessageBoxMessage((List<String>)parametersUnnamed);
            try {
                messageBox.sendMessage(unamedParameters);
            }
            catch (InterruptedException x) {
                throw new IOException(x);
            }
        }
        return result;
    }

    private static String getMessageBoxFolder() {
        if (messageBoxFolder == null) {
            messageBoxFolder = AppPlatform.getApplicationDataFolder() + "/MB";
        }
        return messageBoxFolder;
    }

    public static interface AppNotificationHandler {
        public void handleLaunch(List<String> var1);

        public void handleOpenFilesAction(List<String> var1);

        public void handleMessageBoxFailure(Exception var1);

        public void handleQuitAction();
    }

    private static class MessageBoxMessage
    extends ArrayList<String> {
        static final long serialVersionUID = 10L;

        public MessageBoxMessage(List<String> strings) {
            super(strings);
        }
    }

    private static class MessageBoxDelegate
    implements MessageBox.Delegate<MessageBoxMessage> {
        private final AppNotificationHandler eventHandler;

        public MessageBoxDelegate(AppNotificationHandler eventHandler) {
            assert (eventHandler != null);
            this.eventHandler = eventHandler;
        }

        @Override
        public void messageBoxDidGetMessage(MessageBoxMessage message) {
            assert (!Platform.isFxApplicationThread());
            Platform.runLater(() -> this.eventHandler.handleOpenFilesAction(message));
        }

        @Override
        public void messageBoxDidCatchException(Exception x) {
            assert (!Platform.isFxApplicationThread());
            Platform.runLater(() -> this.eventHandler.handleMessageBoxFailure(x));
        }
    }
}

